/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.velocity.VelocityEvaluator;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.classes.StringClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.web.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.edit.EditException;
import org.xwiki.edit.Editor;
import org.xwiki.edit.EditorManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxContent;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.xml.XMLUtils;

public class TextAreaClass
extends StringClass {
    private static final String FAILED_VELOCITY_EXECUTION_WARNING = "Failed to execute velocity code in text area property [{}]: [{}]";
    private static final String RESTRICTED = "restricted";
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "textarea";
    private static final Logger LOGGER = LoggerFactory.getLogger(TextAreaClass.class);

    public TextAreaClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "Text Area", wclass);
        this.setSize(40);
        this.setRows(5);
    }

    public TextAreaClass() {
        this(null);
    }

    public static EditorType getEditorType(ContentType contentType, EditorType def) {
        if (contentType != null && contentType != ContentType.WIKI_TEXT) {
            return EditorType.PURE_TEXT;
        }
        return def;
    }

    public static EditorType getEditorType(String contentType, EditorType def) {
        return TextAreaClass.getEditorType(ContentType.getByValue(contentType), def);
    }

    public static ContentType getContentType(EditorType editorType, ContentType def) {
        if (editorType != EditorType.PURE_TEXT) {
            return ContentType.WIKI_TEXT;
        }
        return def;
    }

    @Override
    public BaseProperty newProperty() {
        LargeStringProperty property = new LargeStringProperty();
        property.setName(this.getName());
        return property;
    }

    public int getRows() {
        return this.getIntValue("rows");
    }

    public void setRows(int rows) {
        this.setIntValue("rows", rows);
    }

    public String getEditor() {
        EditorType compatibleEditor;
        String editor = this.getStringValue("editor").toLowerCase();
        if (EditorType.getByValue(editor) == null && (compatibleEditor = TextAreaClass.getEditorType(this.getContentType(), null)) != null) {
            return compatibleEditor.value.toLowerCase();
        }
        return editor;
    }

    public void setEditor(String editor) {
        this.setStringValue("editor", editor);
    }

    public void setEditor(EditorType editorType) {
        this.setEditor(editorType.toString());
        ContentType compatible = TextAreaClass.getContentType(editorType, null);
        if (compatible != null) {
            this.setContentType(compatible);
        }
    }

    public String getContentType() {
        String result = this.getStringValue("contenttype").toLowerCase();
        if (result.isEmpty()) {
            result = ContentType.WIKI_TEXT.toString().toLowerCase();
        }
        return result;
    }

    public void setContentType(String contentType) {
        this.setStringValue("contenttype", contentType);
    }

    public void setContentType(ContentType contentType) {
        this.setContentType(contentType.toString());
        EditorType compatible = TextAreaClass.getEditorType(contentType, null);
        if (compatible != null) {
            this.setEditor(compatible);
        }
    }

    public boolean isWysiwyg(XWikiContext context) {
        return "wysiwyg".equals(this.getEditorType(context));
    }

    private String getEditorType(XWikiContext context) {
        String editorType = null;
        if (context != null && context.getRequest() != null) {
            editorType = context.getRequest().get("xeditmode");
        }
        if (this.isEmptyValue(editorType) && this.isEmptyValue(editorType = this.getEditor()) && context != null && context.getWiki() != null) {
            editorType = context.getWiki().getEditorPreference(context);
        }
        return this.isEmptyValue(editorType) ? null : editorType.toLowerCase();
    }

    private boolean isEmptyValue(String value) {
        return StringUtils.isEmpty((CharSequence)value) || "---".equals(value);
    }

    public boolean isWikiContent() {
        String contentType = this.getContentType();
        return contentType != null && !contentType.equals("puretext") && !contentType.equals("velocitycode");
    }

    public boolean isRestricted() {
        return this.getIntValue(RESTRICTED, 0) == 1;
    }

    public void setRestricted(boolean restricted) {
        this.setIntValue(RESTRICTED, restricted ? 1 : 0);
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        String editorType = this.getEditorType(context);
        EditorManager editorManager = Utils.getComponent(EditorManager.class);
        Editor editor = editorManager.getDefaultEditor(SyntaxContent.class, editorType);
        XWikiDocument ownerDocument = this.getObjectDocument(object, context);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String fieldName = prefix + name;
        parameters.put("id", fieldName);
        parameters.put("name", fieldName);
        parameters.put("cols", this.getSize());
        parameters.put("rows", this.getRows());
        parameters.put("disabled", this.isDisabled());
        parameters.put(RESTRICTED, this.isRestricted() || ownerDocument != null && ownerDocument.isRestricted());
        parameters.put("sourceDocumentReference", object.getDocumentReference());
        Syntax syntax = null;
        String contentType = this.getContentType();
        syntax = StringUtils.equalsIgnoreCase((CharSequence)ContentType.PURE_TEXT.toString(), (CharSequence)contentType) || StringUtils.equalsIgnoreCase((CharSequence)ContentType.VELOCITY_CODE.toString(), (CharSequence)contentType) ? Syntax.PLAIN_1_0 : ("puretext".equals(editorType) ? Syntax.PLAIN_1_0 : this.getObjectDocumentSyntax(object, context));
        SyntaxContent syntaxContent = new SyntaxContent(object.getStringValue(name), syntax);
        try {
            buffer.append(editor.render((Object)syntaxContent, parameters));
        }
        catch (EditException e) {
            LOGGER.error("Failed to display the text area property.", (Throwable)e);
        }
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        this.displayView(buffer, name, prefix, object, true, context);
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, boolean isolated, XWikiContext context) {
        String contentTypeString = this.getContentType();
        ContentType contentType = ContentType.getByValue(contentTypeString);
        if (contentType == ContentType.PURE_TEXT) {
            super.displayView(buffer, name, prefix, object, context);
        } else if (contentType == ContentType.VELOCITY_CODE) {
            this.displayVelocityCode(buffer, name, prefix, object, context);
        } else {
            BaseProperty property = (BaseProperty)object.safeget(name);
            if (property != null) {
                String content = property.toText();
                XWikiDocument sdoc = this.getObjectDocument(object, context);
                if (contentType == ContentType.VELOCITYWIKI) {
                    content = this.maybeEvaluateContent(name, isolated, content, sdoc);
                }
                if (sdoc != null) {
                    sdoc = TextAreaClass.ensureContentAuthorIsMetadataAuthor(sdoc);
                    buffer.append(context.getDoc().getRenderedContent(content, sdoc.getSyntax(), this.isRestricted(), sdoc, isolated, context));
                } else {
                    buffer.append(XMLUtils.escapeElementText((String)content));
                }
            }
        }
    }

    private static XWikiDocument ensureContentAuthorIsMetadataAuthor(XWikiDocument sdoc) {
        XWikiDocument result;
        if (!Objects.equals(sdoc.getAuthors().getEffectiveMetadataAuthor(), sdoc.getAuthors().getContentAuthor())) {
            result = sdoc.clone();
            result.getAuthors().setContentAuthor(sdoc.getAuthors().getEffectiveMetadataAuthor());
        } else {
            result = sdoc;
        }
        return result;
    }

    private String maybeEvaluateContent(String name, boolean isolated, String content, XWikiDocument sdoc) {
        if (sdoc != null) {
            AuthorExecutor authorExecutor = Utils.getComponent(AuthorExecutor.class);
            VelocityEvaluator velocityEvaluator = Utils.getComponent(VelocityEvaluator.class);
            try {
                return (String)authorExecutor.call(() -> {
                    String result = this.isDocumentAuthorAllowedToEvaluateScript(sdoc) ? velocityEvaluator.evaluateVelocityNoException(content, isolated ? sdoc.getDocumentReference() : null) : content;
                    return result;
                }, sdoc.getAuthorReference(), sdoc.getDocumentReference());
            }
            catch (Exception e) {
                LOGGER.warn(FAILED_VELOCITY_EXECUTION_WARNING, (Object)name, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return content;
    }

    private void displayVelocityCode(StringBuffer buffer, String name, String prefix, BaseCollection<?> object, XWikiContext context) {
        StringBuffer result = new StringBuffer();
        super.displayView(result, name, prefix, object, context);
        XWikiDocument sdoc = this.getObjectDocument(object, context);
        if (this.getObjectDocumentSyntax(object, context).equals((Object)Syntax.XWIKI_1_0) && sdoc != null) {
            try {
                Utils.getComponent(AuthorExecutor.class).call(() -> {
                    if (this.isDocumentAuthorAllowedToEvaluateScript(sdoc)) {
                        buffer.append(context.getWiki().parseContent(result.toString(), context));
                    } else {
                        buffer.append(result);
                    }
                    return null;
                }, sdoc.getAuthorReference(), sdoc.getDocumentReference());
            }
            catch (Exception e) {
                LOGGER.warn(FAILED_VELOCITY_EXECUTION_WARNING, (Object)name, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                buffer.append(result);
            }
        } else {
            buffer.append(result);
        }
    }

    private boolean isDocumentAuthorAllowedToEvaluateScript(XWikiDocument document) {
        boolean isAllowed;
        boolean bl = isAllowed = !this.isRestricted() && !document.isRestricted();
        if (isAllowed) {
            ContextualAuthorizationManager authorization = Utils.getComponent(ContextualAuthorizationManager.class);
            isAllowed = authorization.hasAccess(Right.SCRIPT);
        }
        return isAllowed;
    }

    private XWikiDocument getObjectDocument(BaseCollection<?> object, XWikiContext context) {
        try {
            XWikiDocument doc = object.getOwnerDocument();
            if (doc == null) {
                doc = context.getWiki().getDocument(object.getDocumentReference(), context);
            }
            return doc;
        }
        catch (Exception e) {
            LOGGER.warn("Error while getting the syntax corresponding to object [{}]. Defaulting to using XWiki 1.0 syntax. Internal error [{}]", object.getReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private Syntax getObjectDocumentSyntax(BaseCollection<?> object, XWikiContext context) {
        XWikiDocument doc = this.getObjectDocument(object, context);
        return doc != null && doc.getSyntax() != null ? doc.getSyntax() : Syntax.XWIKI_1_0;
    }

    public static enum ContentType {
        PURE_TEXT("PureText"),
        WIKI_TEXT("FullyRenderedText"),
        VELOCITY_CODE("VelocityCode"),
        VELOCITYWIKI("VelocityWiki");

        private static final Map<String, ContentType> contentTypeMap;
        private final String value;

        public static ContentType getByValue(String value) {
            return value != null ? contentTypeMap.get(value.toLowerCase()) : null;
        }

        private ContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        static {
            contentTypeMap = Arrays.stream(ContentType.values()).collect(Collectors.toMap(c -> c.value.toLowerCase(), c -> c));
        }
    }

    public static enum EditorType {
        PURE_TEXT("PureText"),
        TEXT("Text"),
        WYSIWYG("Wysiwyg");

        private static final Map<String, EditorType> editorTypeMap;
        private final String value;

        public static EditorType getByValue(String value) {
            return value != null ? editorTypeMap.get(value.toLowerCase()) : null;
        }

        private EditorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        static {
            editorTypeMap = Arrays.stream(EditorType.values()).collect(Collectors.toMap(e -> e.value.toLowerCase(), e -> e));
        }
    }
}

