/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClassCompatibiityAspect;
import com.xpn.xwiki.objects.classes.PropertyClassInterface;
import com.xpn.xwiki.objects.meta.MetaClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.plugin.query.XWikiQuery;
import com.xpn.xwiki.validation.XWikiValidationStatus;
import com.xpn.xwiki.web.Utils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.input;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.hibernate.mapping.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.stability.Unstable;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

public class PropertyClass
extends BaseCollection<ClassPropertyReference>
implements PropertyClassInterface,
Comparable<PropertyClass> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyClass.class);
    private static final String CLASS_DISPLAYER_IDENTIFIER = "class";
    private static final String DOCUMENT_DISPLAYER_IDENTIFIER_PREFIX = "doc:";
    private static final String TEMPLATE_DISPLAYER_IDENTIFIER_PREFIX = "template:";
    private BaseClass xclass;
    private long id;
    private PropertyMetaClass pMetaClass;
    protected String cachedCustomDisplayer;

    public PropertyClass() {
    }

    public PropertyClass(String name, String prettyname, PropertyMetaClass xWikiClass) {
        this.setName(name);
        this.setPrettyName(prettyname);
        this.setxWikiClass(xWikiClass);
        this.setUnmodifiable(false);
        this.setDisabled(false);
    }

    @Override
    protected ClassPropertyReference createReference() {
        return new ClassPropertyReference(this.getName(), this.xclass.getReference());
    }

    @Override
    public BaseClass getXClass(XWikiContext context) {
        return this.getxWikiClass();
    }

    public BaseClass getxWikiClass() {
        if (this.pMetaClass == null) {
            MetaClass metaClass = MetaClass.getMetaClass();
            this.pMetaClass = (PropertyMetaClass)metaClass.get(this.getClassType());
        }
        return this.pMetaClass;
    }

    public void setxWikiClass(BaseClass xWikiClass) {
        this.pMetaClass = (PropertyMetaClass)xWikiClass;
    }

    @Override
    public BaseCollection getObject() {
        return this.xclass;
    }

    @Override
    public void setObject(BaseCollection object) {
        if (this.xclass != object) {
            this.xclass = (BaseClass)object;
            this.referenceCache = null;
            if (object != null) {
                this.setOwnerDocument(object.getOwnerDocument());
                if (this.isDirty()) {
                    this.xclass.setDirty(true);
                }
            }
        }
    }

    public String getFieldFullName() {
        String prefix = this.getObject() != null ? this.getObject().getName() : this.getClassName();
        return prefix + "_" + this.getName();
    }

    @Override
    public long getId() {
        if (this.getObject() == null) {
            return this.id;
        }
        return this.getObject().getId();
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String toString(BaseProperty property) {
        return property.toText();
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        return null;
    }

    public BaseProperty newPropertyfromXML(Element ppcel) throws XWikiException {
        String value = ppcel.getText();
        return this.fromString(value);
    }

    @Override
    public void displayHidden(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        input input2 = new input();
        input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop != null) {
            input2.setValue(prop.toText());
        }
        input2.setType("hidden");
        input2.setName(prefix + name);
        input2.setID(prefix + name);
        buffer.append(input2.toString());
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop != null) {
            buffer.append(prop.toText());
        }
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        input input2 = new input();
        input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop != null) {
            input2.setValue(prop.toText());
        }
        input2.setType("text");
        input2.setName(prefix + name);
        input2.setID(prefix + name);
        input2.setDisabled(this.isDisabled());
        buffer.append(input2.toString());
    }

    public String displayHidden(String name, String prefix, BaseCollection object, XWikiContext context) {
        StringBuffer buffer = new StringBuffer();
        this.displayHidden(buffer, name, prefix, object, context);
        return buffer.toString();
    }

    public String displayHidden(String name, BaseCollection object, XWikiContext context) {
        return this.displayHidden(name, "", object, context);
    }

    public String displayView(String name, String prefix, BaseCollection object, XWikiContext context) {
        StringBuffer buffer = new StringBuffer();
        this.displayView(buffer, name, prefix, object, context);
        return buffer.toString();
    }

    public String displayView(String name, BaseCollection object, XWikiContext context) {
        return this.displayView(name, "", object, context);
    }

    public String displayEdit(String name, String prefix, BaseCollection object, XWikiContext context) {
        StringBuffer buffer = new StringBuffer();
        this.displayEdit(buffer, name, prefix, object, context);
        return buffer.toString();
    }

    public String displayEdit(String name, BaseCollection object, XWikiContext context) {
        return this.displayEdit(name, "", object, context);
    }

    public boolean isCustomDisplayed(XWikiContext context) {
        return StringUtils.isNotEmpty((CharSequence)this.getCachedDefaultCustomDisplayer(context));
    }

    public void displayCustom(StringBuffer buffer, String fieldName, String prefix, String type, BaseObject object, XWikiContext context) throws XWikiException {
        String content = "";
        try {
            ScriptContext scontext = Utils.getComponent(ScriptContextManager.class).getCurrentScriptContext();
            scontext.setAttribute("name", fieldName, 100);
            scontext.setAttribute("prefix", prefix, 100);
            scontext.setAttribute("field", new com.xpn.xwiki.api.PropertyClass(this, context), 100);
            scontext.setAttribute("object", new Object(object, context), 100);
            scontext.setAttribute("type", type, 100);
            scontext.setAttribute("aria-label", this.localizePlainOrKey("core.model.xclass.editClassProperty.textAlternative", this.getTranslatedPrettyName(context)), 100);
            BaseProperty prop = (BaseProperty)object.safeget(fieldName);
            if (prop != null) {
                scontext.setAttribute("value", prop.getValue(), 100);
            } else {
                scontext.setAttribute("value", null, 100);
            }
            String customDisplayer = this.getCachedDefaultCustomDisplayer(context);
            if (StringUtils.isNotEmpty((CharSequence)customDisplayer)) {
                if (customDisplayer.equals(CLASS_DISPLAYER_IDENTIFIER)) {
                    String rawContent = this.getCustomDisplay();
                    XWikiDocument classDocument = this.getObject().getOwnerDocument();
                    String classSyntax = classDocument.getSyntax().toIdString();
                    DocumentReference authorReference = classDocument.getAuthorReference();
                    if (authorReference == null && classDocument.isNew()) {
                        authorReference = context.getUserReference();
                    }
                    content = this.renderContentInContext(rawContent, classSyntax, authorReference, classDocument.getDocumentReference(), classDocument.isRestricted(), context);
                } else if (customDisplayer.startsWith(DOCUMENT_DISPLAYER_IDENTIFIER_PREFIX)) {
                    XWikiDocument displayerDoc = context.getWiki().getDocument(StringUtils.substringAfter((String)customDisplayer, (String)DOCUMENT_DISPLAYER_IDENTIFIER_PREFIX), context);
                    String rawContent = displayerDoc.getContent();
                    String displayerDocSyntax = displayerDoc.getSyntax().toIdString();
                    DocumentReference authorReference = displayerDoc.getContentAuthorReference();
                    content = this.renderContentInContext(rawContent, displayerDocSyntax, authorReference, displayerDoc.getDocumentReference(), context);
                } else if (customDisplayer.startsWith(TEMPLATE_DISPLAYER_IDENTIFIER_PREFIX)) {
                    content = context.getWiki().evaluateTemplate(StringUtils.substringAfter((String)customDisplayer, (String)TEMPLATE_DISPLAYER_IDENTIFIER_PREFIX), context);
                }
            }
        }
        catch (Exception e) {
            throw new XWikiException(7, 7007, "Exception while preparing the custom display of " + fieldName, e, null);
        }
        buffer.append(content);
    }

    @Deprecated
    protected String renderContentInContext(String content, String syntax, DocumentReference authorReference, XWikiContext context) throws Exception {
        return this.renderContentInContext(content, syntax, authorReference, null, context);
    }

    protected String renderContentInContext(String content, String syntax, DocumentReference authorReference, DocumentReference secureDocument, XWikiContext context) throws Exception {
        return (String)Utils.getComponent(AuthorExecutor.class).call(() -> context.getDoc().getRenderedContent(content, syntax, context), authorReference, secureDocument);
    }

    @Unstable
    protected String renderContentInContext(String content, String syntax, DocumentReference authorReference, DocumentReference secureDocument, boolean restricted, XWikiContext context) throws Exception {
        return (String)Utils.getComponent(AuthorExecutor.class).call(() -> context.getDoc().getRenderedContent(content, syntax, restricted, context), authorReference, secureDocument);
    }

    @Override
    public String getClassName() {
        BaseClass bclass = this.getxWikiClass();
        return bclass == null ? "" : bclass.getName();
    }

    @Override
    public String getName() {
        return this.getStringValue("name");
    }

    @Override
    public void setName(String name) {
        this.setStringValue("name", name);
        this.referenceCache = null;
    }

    public String getCustomDisplay() {
        return this.getStringValue("customDisplay");
    }

    public void setCustomDisplay(String value) {
        this.setLargeStringValue("customDisplay", value);
    }

    @Override
    public String getPrettyName() {
        return this.getStringValue("prettyName");
    }

    public String getPrettyName(XWikiContext context) {
        return this.getTranslatedPrettyName(context);
    }

    public String getTranslatedPrettyName(XWikiContext context) {
        String msgName = this.getFieldFullName();
        if (context == null || context.getWiki() == null) {
            return this.getPrettyName();
        }
        String prettyName = this.localizePlain(msgName, new java.lang.Object[0]);
        if (prettyName == null) {
            return this.getPrettyName();
        }
        return prettyName;
    }

    @Override
    public void setPrettyName(String prettyName) {
        this.setStringValue("prettyName", prettyName);
    }

    private String getLocalizedPropertyValue(String property) {
        String propertyName = String.format("%s_%s", this.getFieldFullName(), property);
        String propertyValue = this.localizePlain(propertyName, new java.lang.Object[0]);
        if (propertyValue == null && StringUtils.isNotBlank((CharSequence)(propertyName = this.getLargeStringValue(property)))) {
            propertyValue = this.localizePlainOrKey(propertyName, propertyName);
        }
        return propertyValue;
    }

    public String getHint() {
        return this.getLocalizedPropertyValue("hint");
    }

    public void setHint(String hint) {
        this.setLargeStringValue("hint", hint);
    }

    public String getTooltip() {
        return this.getLargeStringValue("tooltip");
    }

    public String getTooltip(XWikiContext context) {
        return this.getLocalizedPropertyValue("tooltip");
    }

    public void setTooltip(String tooltip) {
        this.setLargeStringValue("tooltip", tooltip);
    }

    @Override
    public int getNumber() {
        return this.getIntValue("number");
    }

    @Override
    public void setNumber(int number) {
        this.setIntValue("number", number);
    }

    public String getClassType() {
        return StringUtils.removeEnd((String)this.getClass().getSimpleName(), (String)"Class");
    }

    @Deprecated
    public void setClassType(String type) {
        LOGGER.warn("The property class type cannot be modified!");
    }

    @Override
    protected void detachOwner() {
        super.detachOwner();
        this.setObject(null);
    }

    @Override
    protected void cloneOwner() {
        super.cloneOwner();
        if (this.getOwnerDocument() != null && this.getObject() != null) {
            this.setObject(this.ownerDocument.getXClass());
        }
    }

    @Override
    public PropertyClass clone() {
        return (PropertyClass)super.clone();
    }

    public PropertyClass clone(boolean detach) {
        return (PropertyClass)super.clone(detach);
    }

    @Override
    public Element toXML(BaseClass bclass) {
        return this.toXML();
    }

    @Override
    public Element toXML() {
        DOMElement pel = new DOMElement(this.getName());
        Iterator it = this.getSortedIterator();
        while (it.hasNext()) {
            BaseProperty bprop = (BaseProperty)it.next();
            pel.add(bprop.toXML());
        }
        DOMElement el = new DOMElement("classType");
        String classType = this.getClassType();
        if (this.getClass().getSimpleName().equals(classType + "Class")) {
            classType = this.getClass().getName();
        }
        el.addText(classType);
        pel.add((Element)el);
        return pel;
    }

    @Override
    public void fromXML(Element element) throws XWikiException {
        super.fromXML(element);
    }

    @Override
    public String toFormString() {
        return this.toString();
    }

    public void initLazyCollections() {
    }

    public boolean isUnmodifiable() {
        return this.getIntValue("unmodifiable") == 1;
    }

    public void setUnmodifiable(boolean unmodifiable) {
        if (unmodifiable) {
            this.setIntValue("unmodifiable", 1);
        } else {
            this.setIntValue("unmodifiable", 0);
        }
    }

    public boolean isDisabled() {
        return this.getIntValue("disabled", 0) == 1;
    }

    public void setDisabled(boolean disabled) {
        if (disabled) {
            this.setIntValue("disabled", 1);
        } else {
            this.setIntValue("disabled", 0);
        }
    }

    public BaseProperty fromStringArray(String[] strings) throws XWikiException {
        return this.fromString(strings[0]);
    }

    public boolean isValidColumnTypes(Property hibprop) {
        return true;
    }

    @Override
    public BaseProperty fromValue(java.lang.Object value) {
        BaseProperty property = this.newProperty();
        if (property != null) {
            property.setValue(value);
            return property;
        }
        return null;
    }

    @Override
    public BaseProperty newProperty() {
        return new BaseProperty();
    }

    public void setValidationRegExp(String validationRegExp) {
        this.setStringValue("validationRegExp", validationRegExp);
    }

    public String getValidationRegExp() {
        return this.getStringValue("validationRegExp");
    }

    public String getValidationMessage() {
        return this.getStringValue("validationMessage");
    }

    public void setValidationMessage(String validationMessage) {
        this.setStringValue("validationMessage", validationMessage);
    }

    public boolean validateProperty(BaseProperty property, XWikiContext context) {
        String regexp = this.getValidationRegExp();
        if (regexp == null || regexp.trim().equals("")) {
            return true;
        }
        String value = property == null || property.getValue() == null ? "" : property.getValue().toString();
        try {
            if (context.getUtil().match(regexp, value)) {
                return true;
            }
            XWikiValidationStatus.addErrorToContext(this.getObject() == null ? "" : this.getObject().getName(), this.getName(), this.getTranslatedPrettyName(context), this.getValidationMessage(), context);
            return false;
        }
        catch (Exception e) {
            XWikiValidationStatus.addExceptionToContext(this.getObject() == null ? "" : this.getObject().getName(), this.getName(), e, context);
            return false;
        }
    }

    @Override
    public void flushCache() {
        this.cachedCustomDisplayer = null;
    }

    @Override
    public int compareTo(PropertyClass other) {
        int result = this.getNumber() - other.getNumber();
        if (result == 0) {
            result = this.getName().compareTo(other.getName());
        }
        return result;
    }

    protected String getFullQueryPropertyName() {
        return "obj." + this.getName();
    }

    protected String getCachedDefaultCustomDisplayer(XWikiContext context) {
        String customDisplay = this.getCustomDisplay();
        if (StringUtils.isNotEmpty((CharSequence)customDisplay)) {
            return CLASS_DISPLAYER_IDENTIFIER;
        }
        if (this.cachedCustomDisplayer == null) {
            this.cachedCustomDisplayer = this.getDefaultCustomDisplayer(this.getTypeName(), context);
        }
        return this.cachedCustomDisplayer;
    }

    protected String getDefaultCustomDisplayer(String propertyClassName, XWikiContext context) {
        LOGGER.debug("Looking up default custom displayer for property class name [{}]", (java.lang.Object)propertyClassName);
        try {
            String pageName = StringUtils.capitalize((String)propertyClassName) + "Displayer";
            DocumentReference reference = new DocumentReference(context.getWikiId(), "XWiki", pageName);
            if (context.getWiki().exists(reference, context)) {
                LOGGER.debug("Found default custom displayer for property class name in local wiki: [{}]", (java.lang.Object)pageName);
                return "doc:XWiki." + pageName;
            }
            if (!context.isMainWiki()) {
                reference = new DocumentReference(context.getMainXWiki(), "XWiki", pageName);
                if (context.getWiki().exists(reference, context)) {
                    LOGGER.debug("Found default custom displayer for property class name in main wiki: [{}]", (java.lang.Object)pageName);
                    return DOCUMENT_DISPLAYER_IDENTIFIER_PREFIX + context.getMainXWiki() + ":XWiki." + pageName;
                }
            }
            String templateName = "displayer_" + propertyClassName + ".vm";
            TemplateManager templateManager = Utils.getComponent(TemplateManager.class);
            Template existingTemplate = templateManager.getTemplate(templateName);
            if (existingTemplate != null) {
                LOGGER.debug("Found default custom displayer for property class name as template: [{}]", (java.lang.Object)templateName);
                return TEMPLATE_DISPLAYER_IDENTIFIER_PREFIX + templateName;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error finding if property [{}] has a custom displayer. Considering that there's no custom displayer.", (java.lang.Object)propertyClassName, (java.lang.Object)e);
        }
        return null;
    }

    private String getTypeName() {
        return StringUtils.substringBeforeLast((String)this.getClass().getSimpleName(), (String)"Class").toLowerCase();
    }

    public <T extends EntityReference> void mergeProperty(BaseProperty<T> currentProperty, BaseProperty<T> previousProperty, BaseProperty<T> newProperty, MergeConfiguration configuration, XWikiContext context, MergeResult mergeResult) {
        currentProperty.merge(previousProperty, newProperty, configuration, context, mergeResult);
    }

    @Deprecated
    public String displaySearch(String string, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return PropertyClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_PropertyClassCompatibiityAspect$com_xpn_xwiki_objects_classes_PropertyClass$displaySearch(this, string, xWikiCriteria, xWikiContext);
    }

    @Deprecated
    public String displaySearch(String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return PropertyClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_PropertyClassCompatibiityAspect$com_xpn_xwiki_objects_classes_PropertyClass$displaySearch(this, string, string2, xWikiCriteria, xWikiContext);
    }

    @Override
    @Deprecated
    public void displaySearch(StringBuffer stringBuffer, String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        PropertyClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_PropertyClassCompatibiityAspect$com_xpn_xwiki_objects_classes_PropertyClass$displaySearch(this, stringBuffer, string, string2, xWikiCriteria, xWikiContext);
    }

    @Deprecated
    public void fromSearchMap(XWikiQuery xWikiQuery, Map<String, String[]> map) {
        PropertyClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_PropertyClassCompatibiityAspect$com_xpn_xwiki_objects_classes_PropertyClass$fromSearchMap(this, xWikiQuery, map);
    }

    @Override
    public BaseClass getxWikiClass(XWikiContext xWikiContext) {
        return PropertyClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_PropertyClassCompatibiityAspect$com_xpn_xwiki_objects_classes_PropertyClass$getxWikiClass(this, xWikiContext);
    }

    @Deprecated
    public void makeQuery(Map<String, java.lang.Object> map, String string, XWikiCriteria xWikiCriteria, List<String> list) {
        PropertyClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_PropertyClassCompatibiityAspect$com_xpn_xwiki_objects_classes_PropertyClass$makeQuery(this, map, string, xWikiCriteria, list);
    }
}

