/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.DoubleProperty;
import com.xpn.xwiki.objects.FloatProperty;
import com.xpn.xwiki.objects.IntegerProperty;
import com.xpn.xwiki.objects.LongProperty;
import com.xpn.xwiki.objects.NumberProperty;
import com.xpn.xwiki.objects.classes.NumberClassCompatibiityAspect;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.plugin.query.XWikiQuery;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberClass
extends PropertyClass {
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_LONG = "long";
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "number";
    private static final Logger LOG = LoggerFactory.getLogger(NumberClass.class);

    public NumberClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "Number", wclass);
        this.setSize(30);
        this.setNumberType(TYPE_LONG);
    }

    public NumberClass() {
        this(null);
    }

    public int getSize() {
        return this.getIntValue("size");
    }

    public void setSize(int size) {
        this.setIntValue("size", size);
    }

    public String getNumberType() {
        return this.getStringValue("numberType");
    }

    public void setNumberType(String ntype) {
        this.setStringValue("numberType", ntype);
    }

    @Override
    public BaseProperty newProperty() {
        String ntype = this.getNumberType();
        NumberProperty property = ntype.equals(TYPE_INTEGER) ? new IntegerProperty() : (ntype.equals(TYPE_FLOAT) ? new FloatProperty() : (ntype.equals(TYPE_DOUBLE) ? new DoubleProperty() : new LongProperty()));
        property.setName(this.getName());
        return property;
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        BaseProperty property = this.newProperty();
        String ntype = this.getNumberType();
        Number nvalue = null;
        try {
            if (ntype.equals(TYPE_INTEGER)) {
                if (value != null && !value.equals("")) {
                    nvalue = Integer.valueOf(value);
                }
            } else if (ntype.equals(TYPE_FLOAT)) {
                if (value != null && !value.equals("")) {
                    nvalue = Float.valueOf(value);
                }
            } else if (ntype.equals(TYPE_DOUBLE)) {
                if (value != null && !value.equals("")) {
                    nvalue = Double.valueOf(value);
                }
            } else if (value != null && !value.equals("")) {
                nvalue = Long.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            throw new XWikiException(String.format("Error when parsing [%s] to type [%s]", value, ntype), e);
        }
        property.setValue(nvalue);
        return property;
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        input input2 = new input();
        input2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop != null) {
            input2.setValue(prop.toText());
        }
        input2.setType("text");
        input2.setName(prefix + name);
        input2.setID(prefix + name);
        input2.setSize(this.getSize());
        input2.setDisabled(this.isDisabled());
        buffer.append(input2.toString());
    }

    public /* synthetic */ String ajc$superDispatch$com_xpn_xwiki_objects_classes_NumberClass$getFullQueryPropertyName() {
        return super.getFullQueryPropertyName();
    }

    @Override
    @Deprecated
    public void displaySearch(StringBuffer stringBuffer, String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        NumberClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_NumberClassCompatibiityAspect$com_xpn_xwiki_objects_classes_NumberClass$displaySearch(this, stringBuffer, string, string2, xWikiCriteria, xWikiContext);
    }

    @Override
    @Deprecated
    public void fromSearchMap(XWikiQuery xWikiQuery, Map<String, String[]> map) throws XWikiException {
        NumberClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_NumberClassCompatibiityAspect$com_xpn_xwiki_objects_classes_NumberClass$fromSearchMap(this, xWikiQuery, map);
    }

    @Override
    @Deprecated
    public void makeQuery(Map<String, Object> map, String string, XWikiCriteria xWikiCriteria, List<String> list) {
        NumberClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_NumberClassCompatibiityAspect$com_xpn_xwiki_objects_classes_NumberClass$makeQuery(this, map, string, xWikiCriteria, list);
    }
}

