/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.EntityReference;

public class GroupsClass
extends ListClass {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupsClass.class);
    private static final String COMMA = ",";
    private static final String META_PROPERTY_USES_LIST = "usesList";

    public GroupsClass(PropertyMetaClass metaClass) {
        super("groupslist", "Groups List", metaClass);
        this.setSize(20);
        this.setDisplayType("input");
        this.setPicker(true);
    }

    public GroupsClass() {
        this(null);
    }

    @Override
    protected String getFirstSeparator() {
        return COMMA;
    }

    @Override
    public List<String> getList(XWikiContext context) {
        try {
            return context.getWiki().getGroupService(context).getAllMatchedGroups(null, false, 0, 0, null, context);
        }
        catch (XWikiException e) {
            LOGGER.warn("Failed to retrieve the list of groups.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Map<String, ListItem> getMap(XWikiContext context) {
        return new HashMap<String, ListItem>();
    }

    @Deprecated
    public boolean isUsesList() {
        return this.getIntValue(META_PROPERTY_USES_LIST) == 1;
    }

    @Deprecated
    public void setUsesList(boolean usesList) {
        this.setIntValue(META_PROPERTY_USES_LIST, usesList ? 1 : 0);
    }

    @Override
    public BaseProperty newProperty() {
        LargeStringProperty property = new LargeStringProperty();
        property.setName(this.getName());
        return property;
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        BaseProperty prop = this.newProperty();
        prop.setValue(value);
        return prop;
    }

    @Override
    public BaseProperty fromStringArray(String[] strings) {
        List<String> list = strings.length == 1 && (this.getDisplayType().equals("input") || this.isMultiSelect()) ? GroupsClass.getListFromString(strings[0], this.getSeparators(), false) : Arrays.asList(strings);
        BaseProperty prop = this.newProperty();
        this.fromList(prop, list);
        return prop;
    }

    @Override
    public void fromList(BaseProperty<?> property, List<String> list) {
        this.fromList(property, list, true);
    }

    public String getText(String value, XWikiContext context) {
        if (value.indexOf(":") != -1) {
            return value;
        }
        return value.substring(value.lastIndexOf(".") + 1);
    }

    public static List<String> getListFromString(String value) {
        return GroupsClass.getListFromString(value, COMMA, false, true);
    }

    @Override
    public BaseProperty newPropertyfromXML(Element ppcel) throws XWikiException {
        String value = ppcel.getText();
        return this.fromString(value);
    }

    @Override
    public List<String> toList(BaseProperty<?> property) {
        List<Object> selectlist = property == null ? new ArrayList() : GroupsClass.getListFromString((String)property.getValue());
        return selectlist;
    }

    @Override
    public <T extends EntityReference> void mergeProperty(BaseProperty<T> currentProperty, BaseProperty<T> previousProperty, BaseProperty<T> newProperty, MergeConfiguration configuration, XWikiContext xcontext, MergeResult mergeResult) {
        this.mergeNotOrderedListProperty(currentProperty, previousProperty, newProperty, configuration, xcontext, mergeResult);
    }
}

