/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.DateProperty;
import com.xpn.xwiki.objects.classes.DateClassCompatibiityAspect;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.plugin.query.XWikiQuery;
import com.xpn.xwiki.web.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.xar.internal.property.DateXarObjectPropertySerializer;

public class DateClass
extends PropertyClass {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DateClass.class);
    private static final String META_PROPERTY_PICKER = "picker";
    private static final String META_PROPERTY_SIZE = "size";
    private static final String META_PROPERTY_EMPTY_IS_TODAY = "emptyIsToday";
    private static final String META_PROPERTY_DATE_FORMAT = "dateFormat";
    private LocalizationContext localizationContext;

    public DateClass(PropertyMetaClass metaClass) {
        super("date", "Date", metaClass);
        this.setSize(20);
        this.setDateFormat("dd/MM/yyyy HH:mm:ss");
        this.setEmptyIsToday(1);
        this.setPicker(1);
    }

    public DateClass() {
        this(null);
    }

    public int getPicker() {
        return this.getIntValue(META_PROPERTY_PICKER);
    }

    public void setPicker(int picker) {
        this.setIntValue(META_PROPERTY_PICKER, picker);
    }

    public int getSize() {
        return this.getIntValue(META_PROPERTY_SIZE);
    }

    public void setSize(int size) {
        this.setIntValue(META_PROPERTY_SIZE, size);
    }

    public int getEmptyIsToday() {
        return this.getIntValue(META_PROPERTY_EMPTY_IS_TODAY);
    }

    public void setEmptyIsToday(int emptyIsToday) {
        this.setIntValue(META_PROPERTY_EMPTY_IS_TODAY, emptyIsToday);
    }

    public String getDateFormat() {
        return this.getStringValue(META_PROPERTY_DATE_FORMAT);
    }

    public void setDateFormat(String format) {
        this.setStringValue(META_PROPERTY_DATE_FORMAT, format);
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        BaseProperty property = this.newProperty();
        if (StringUtils.isEmpty((CharSequence)value)) {
            if (this.getEmptyIsToday() == 1) {
                property.setValue(new Date());
            }
            return property;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat(), this.getCurrentLocale());
            property.setValue(sdf.parse(value));
            return property;
        }
        catch (ParseException e) {
            throw new XWikiException(String.format("Error when parsing [%s] with format [%s] and locale [%s]", value, this.getDateFormat(), this.getCurrentLocale()), e);
        }
    }

    @Override
    public BaseProperty newProperty() {
        DateProperty property = new DateProperty();
        property.setName(this.getName());
        return property;
    }

    public String toFormString(BaseProperty property) {
        return property.getValue() == null ? "" : new SimpleDateFormat(this.getDateFormat(), this.getCurrentLocale()).format(property.getValue());
    }

    @Override
    public BaseProperty newPropertyfromXML(Element element) {
        String value = element.getText();
        BaseProperty property = this.newProperty();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return property;
        }
        property.setValue(DateXarObjectPropertySerializer.parseDate((String)value));
        return property;
    }

    private LocalizationContext getLocalizationContext() {
        if (this.localizationContext == null) {
            this.localizationContext = Utils.getComponent(LocalizationContext.class);
        }
        return this.localizationContext;
    }

    private Locale getCurrentLocale() {
        try {
            return this.getLocalizationContext().getCurrentLocale();
        }
        catch (Exception e) {
            Locale defaultLocale = Locale.getDefault();
            LOGGER.warn("Failed to get the context locale: [{}]. Continue using the default JVM locale [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)defaultLocale);
            return defaultLocale;
        }
    }

    @Override
    @Deprecated
    public void displaySearch(StringBuffer stringBuffer, String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        DateClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_DateClassCompatibiityAspect$com_xpn_xwiki_objects_classes_DateClass$displaySearch(this, stringBuffer, string, string2, xWikiCriteria, xWikiContext);
    }

    @Override
    @Deprecated
    public void fromSearchMap(XWikiQuery xWikiQuery, Map<String, String[]> map) throws XWikiException {
        DateClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_DateClassCompatibiityAspect$com_xpn_xwiki_objects_classes_DateClass$fromSearchMap(this, xWikiQuery, map);
    }
}

