/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.ListProperty;
import com.xpn.xwiki.objects.classes.DBListClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.script.ScriptContextManager;

public class DBTreeListClass
extends DBListClass {
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "dbtreelist";
    private static final Logger LOGGER = LoggerFactory.getLogger(DBTreeListClass.class);
    private List<ListItem> cachedDBTreeList;

    public DBTreeListClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "DB Tree List", wclass);
    }

    public DBTreeListClass() {
        this(null);
    }

    public String getParentField() {
        return this.getStringValue("parentField");
    }

    public void setParentField(String parentField) {
        this.setStringValue("parentField", parentField);
    }

    protected List<ListItem> getCachedDBTreeList(XWikiContext context) {
        if (this.isCache()) {
            return this.cachedDBTreeList;
        }
        return (List)context.get(context.getWikiId() + ":" + this.getFieldFullName() + "-tree");
    }

    protected void setCachedDBTreeList(List<ListItem> cachedDBTreeList, XWikiContext context) {
        if (this.isCache()) {
            this.cachedDBTreeList = cachedDBTreeList;
        } else {
            context.put(context.getWikiId() + ":" + this.getFieldFullName() + "-tree", cachedDBTreeList);
        }
    }

    public Map<String, List<ListItem>> getTreeMap(XWikiContext context) {
        List<ListItem> list = this.getDBList(context);
        HashMap<String, List<ListItem>> map = new HashMap<String, List<ListItem>>();
        if (list == null || list.size() == 0) {
            return map;
        }
        List<String> validParents = this.getList(context);
        for (ListItem item : list) {
            if (validParents.contains(item.getParent())) {
                this.addToList(map, item.getParent(), item);
                continue;
            }
            this.addToList(map, "", item);
        }
        return map;
    }

    protected List<ListItem> getTreeList(Map<String, List<ListItem>> treemap, Map<String, ListItem> map, XWikiContext context) {
        List<ListItem> list = this.getCachedDBTreeList(context);
        if (list == null) {
            list = new ArrayList<ListItem>();
            this.addToTreeList(list, treemap, map, "", context);
            this.setCachedDBTreeList(list, context);
        }
        return list;
    }

    protected void addToTreeList(List<ListItem> treelist, Map<String, List<ListItem>> treemap, Map<String, ListItem> map, String parent, XWikiContext context) {
        List<ListItem> list = treemap.get(parent);
        if (list != null) {
            for (ListItem item : list) {
                ListItem item2 = new ListItem(item.getId(), this.getDisplayValue(item.getId(), "", map, context), item.getParent());
                treelist.add(item2);
                this.addToTreeList(treelist, treemap, map, item.getId(), context);
            }
        }
    }

    protected void addToList(Map<String, List<ListItem>> map, String key, ListItem item) {
        List<ListItem> list = map.get(key);
        if (list == null) {
            list = new ArrayList<ListItem>();
            map.put(key, list);
        }
        list.add(item);
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        List<String> selectlist;
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop == null) {
            selectlist = new ArrayList<String>();
        } else if (prop instanceof ListProperty) {
            selectlist = ((ListProperty)prop).getList();
        } else {
            selectlist = new ArrayList();
            selectlist.add(String.valueOf(prop.getValue()));
        }
        String result = this.displayFlatView(selectlist, context);
        if (result.equals("")) {
            super.displayView(buffer, name, prefix, object, context);
        } else {
            buffer.append(result);
        }
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        BaseProperty prop = (BaseProperty)object.safeget(name);
        List<String> selectlist = this.toList(prop);
        if (this.isPicker()) {
            String result = this.displayTree(name, prefix, selectlist, "edit", context);
            if (result.equals("")) {
                this.displayTreeSelectEdit(buffer, name, prefix, object, context);
            } else {
                this.displayHidden(buffer, name, prefix, object, context);
                buffer.append(result);
            }
        } else {
            this.displayTreeSelectEdit(buffer, name, prefix, object, context);
        }
    }

    private String displayFlatView(List<String> selectlist, XWikiContext context) {
        Map<String, ListItem> map = this.getMap(context);
        Map<String, List<ListItem>> treemap = this.getTreeMap(context);
        List<ListItem> fullTreeList = this.getTreeList(treemap, map, context);
        ArrayList<List<ListItem>> resList = new ArrayList<List<ListItem>>(selectlist.size());
        for (String item : selectlist) {
            List<ListItem> itemPath = this.getItemPath(item, fullTreeList, new ArrayList<ListItem>());
            this.mergeItems(itemPath, resList);
        }
        return this.renderItemsList(resList);
    }

    protected String renderItemsList(List<List<ListItem>> resList) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < resList.size(); ++i) {
            List<ListItem> items = resList.get(i);
            for (int j = 0; j < items.size(); ++j) {
                ListItem item = items.get(j);
                buff.append(item.getValue());
                if (j >= items.size() - 1) continue;
                buff.append(" &gt; ");
            }
            if (i >= resList.size() - 1) continue;
            buff.append("<br />");
        }
        return buff.toString();
    }

    private void mergeItems(List<ListItem> itemPath, List<List<ListItem>> resList) {
        if (itemPath == null || itemPath.size() == 0) {
            return;
        }
        for (int i = 0; i < resList.size(); ++i) {
            ListItem item2;
            ListItem item1;
            List<ListItem> items = resList.get(i);
            if (items.size() < itemPath.size()) {
                item1 = items.get(items.size() - 1);
                if (!item1.equals(item2 = itemPath.get(items.size() - 1))) continue;
                resList.set(i, itemPath);
                return;
            }
            item1 = items.get(itemPath.size() - 1);
            if (!item1.equals(item2 = itemPath.get(itemPath.size() - 1))) continue;
            return;
        }
        resList.add(itemPath);
    }

    private List<ListItem> getItemPath(String item, List<ListItem> treeList, ArrayList<ListItem> resList) {
        for (ListItem tmpItem : treeList) {
            if (!item.equals(tmpItem.getId())) continue;
            if (tmpItem.getParent().length() > 0) {
                this.getItemPath(tmpItem.getParent(), treeList, resList);
            }
            resList.add(tmpItem);
            return resList;
        }
        return null;
    }

    private String displayTree(String name, String prefix, List<String> selectlist, String mode, XWikiContext context) {
        ScriptContextManager scriptManager = Utils.getComponent(ScriptContextManager.class);
        ScriptContext scontext = scriptManager.getCurrentScriptContext();
        Map<String, ListItem> map = this.getMap(context);
        Map<String, List<ListItem>> treemap = this.getTreeMap(context);
        scontext.setAttribute("selectlist", selectlist, 100);
        scontext.setAttribute("fieldname", prefix + name, 100);
        scontext.setAttribute("tree", map, 100);
        scontext.setAttribute("treelist", this.getTreeList(treemap, map, context), 100);
        scontext.setAttribute("treemap", treemap, 100);
        scontext.setAttribute("mode", mode, 100);
        return context.getWiki().parseTemplate("treeview.vm", context);
    }

    protected void addToSelect(select select2, List<String> selectlist, Map<String, ListItem> map, Map<String, List<ListItem>> treemap, String parent, String level, XWikiContext context) {
        List<ListItem> list = treemap.get(parent);
        if (list != null) {
            for (ListItem item : list) {
                String display = level + this.getDisplayValue(item.getId(), "", map, context);
                option option2 = new option(display, item.getId());
                option2.addElement(display);
                if (selectlist.contains(item.getId())) {
                    option2.setSelected(true);
                }
                select2.addElement((Element)option2);
                this.addToSelect(select2, selectlist, map, treemap, item.getId(), level + "\u00a0", context);
            }
        }
    }

    protected void displayTreeSelectEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        List<Object> selectlist;
        select select2 = new select(prefix + name, 1);
        select2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        select2.setMultiple(this.isMultiSelect());
        select2.setSize(this.getSize());
        select2.setName(prefix + name);
        select2.setID(prefix + name);
        select2.setDisabled(this.isDisabled());
        Map<String, ListItem> map = this.getMap(context);
        Map<String, List<ListItem>> treemap = this.getTreeMap(context);
        BaseProperty prop = (BaseProperty)object.safeget(name);
        if (prop == null) {
            selectlist = new ArrayList();
        } else if (prop instanceof ListProperty) {
            selectlist = ((ListProperty)prop).getList();
        } else {
            selectlist = new ArrayList();
            selectlist.add(String.valueOf(prop.getValue()));
        }
        this.addToSelect(select2, selectlist, map, treemap, "", "", context);
        buffer.append(select2.toString());
    }

    @Override
    public String getQuery(XWikiContext context) {
        Object sql = this.getSql();
        if (StringUtils.isBlank((CharSequence)sql) && context.getWiki().getHibernateStore() != null) {
            boolean usesDoc;
            boolean hasParentField;
            String classname = StringUtils.defaultString((String)this.getClassname());
            String idField = StringUtils.defaultString((String)this.getIdField());
            String valueField = StringUtils.defaultString((String)this.getValueField());
            String parentField = StringUtils.defaultString((String)this.getParentField());
            boolean hasClassname = !StringUtils.isBlank((CharSequence)classname);
            boolean hasIdField = !StringUtils.isBlank((CharSequence)idField);
            boolean hasValueField = !StringUtils.isBlank((CharSequence)valueField);
            boolean bl = hasParentField = !StringUtils.isBlank((CharSequence)parentField);
            if (!hasIdField && !hasValueField) {
                sql = hasClassname ? "select distinct doc.fullName, doc.fullName, " + (hasParentField ? parentField : "doc.parent") + " from XWikiDocument as doc, BaseObject as obj where doc.fullName=obj.name and obj.className='" + classname + "'" : "select doc.name from XWikiDocument doc where 1 = 0";
                return sql;
            }
            if (!hasIdField && hasValueField) {
                idField = valueField;
            } else if (hasIdField && !hasValueField) {
                valueField = idField;
            }
            if (!hasParentField) {
                parentField = "doc.parent";
            }
            boolean usesObj = hasClassname || idField.startsWith("obj.") || valueField.startsWith("obj.") || parentField.startsWith("obj.");
            boolean bl2 = usesDoc = idField.startsWith("doc.") || valueField.startsWith("doc.") || parentField.startsWith("doc.");
            if (!(idField.startsWith("obj.") && valueField.startsWith("obj.") && parentField.startsWith("obj.") || hasClassname)) {
                usesDoc = true;
            }
            StringBuffer select2 = new StringBuffer("select distinct ");
            ArrayList<String> fromStatements = new ArrayList<String>();
            ArrayList<Object> whereStatements = new ArrayList<Object>();
            if (usesDoc) {
                fromStatements.add("XWikiDocument as doc");
                if (usesObj) {
                    whereStatements.add("doc.fullName=obj.name");
                }
            }
            if (usesObj) {
                fromStatements.add("BaseObject as obj");
                if (hasClassname) {
                    whereStatements.add("obj.className='" + classname + "'");
                }
            }
            if (idField.startsWith("doc.") || idField.startsWith("obj.")) {
                select2.append(idField);
            } else if (!hasClassname) {
                select2.append("doc." + idField);
            } else {
                select2.append("idprop.value");
                fromStatements.add("StringProperty as idprop");
                whereStatements.add("obj.id=idprop.id.id and idprop.id.name='" + idField + "'");
            }
            if (valueField.startsWith("doc.") || valueField.startsWith("obj.")) {
                select2.append(", ").append(valueField);
            } else if (!hasClassname) {
                select2.append(", doc." + valueField);
            } else if (valueField.equals(idField)) {
                select2.append(", idprop.value");
            } else {
                select2.append(", valueprop.value");
                fromStatements.add("StringProperty as valueprop");
                whereStatements.add("obj.id=valueprop.id.id and valueprop.id.name='" + valueField + "'");
            }
            if (parentField.startsWith("doc.") || parentField.startsWith("obj.")) {
                select2.append(", ").append(parentField);
            } else if (!hasClassname) {
                select2.append(", doc." + parentField);
            } else if (parentField.equals(idField)) {
                select2.append(", idprop.value");
            } else if (parentField.equals(valueField)) {
                select2.append(", valueprop.value");
            } else {
                select2.append(", parentprop.value");
                fromStatements.add("StringProperty as parentprop");
                whereStatements.add("obj.id=parentprop.id.id and parentprop.id.name='" + parentField + "'");
            }
            select2.append(" from ");
            select2.append(StringUtils.join(fromStatements.iterator(), (String)", "));
            if (whereStatements.size() > 0) {
                select2.append(" where ");
                select2.append(StringUtils.join(whereStatements.iterator(), (String)" and "));
            }
            sql = select2.toString();
        }
        try {
            sql = context.getWiki().parseContent((String)sql, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse SQL script [" + (String)sql + "]. Continuing with non-rendered script.", (Throwable)e);
        }
        return sql;
    }
}

