/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.xml.XMLAttributeValueFilter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.IntegerProperty;
import com.xpn.xwiki.objects.classes.BooleanClassCompatibiityAspect;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.plugin.query.XWikiQuery;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.Filter;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.xwiki.xml.XMLUtils;

public class BooleanClass
extends PropertyClass {
    private static final long serialVersionUID = 1L;
    private static final String XCLASSNAME = "boolean";
    private static final Pattern TRUE_PATTERN = Pattern.compile("yes|true", 2);
    private static final Pattern FALSE_PATTERN = Pattern.compile("no|false", 2);

    public BooleanClass(PropertyMetaClass wclass) {
        super(XCLASSNAME, "Boolean", wclass);
    }

    public BooleanClass() {
        this(null);
        this.setDisplayFormType("select");
    }

    public void setDisplayType(String type) {
        this.setStringValue("displayType", type);
    }

    public String getDisplayType() {
        String dtype = this.getStringValue("displayType");
        if (dtype == null || dtype.equals("")) {
            return "yesno";
        }
        return dtype;
    }

    public String getDisplayFormType() {
        String dtype = this.getStringValue("displayFormType");
        if (dtype == null || dtype.equals("")) {
            return "radio";
        }
        return dtype;
    }

    public void setDisplayFormType(String type) {
        this.setStringValue("displayFormType", type);
    }

    public void setDefaultValue(int dvalue) {
        this.setIntValue("defaultValue", dvalue);
    }

    public int getDefaultValue() {
        return this.getIntValue("defaultValue", -1);
    }

    @Override
    public BaseProperty fromString(String value) throws XWikiException {
        BaseProperty property = this.newProperty();
        Integer nvalue = null;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if (StringUtils.isNumeric((CharSequence)value)) {
                nvalue = Integer.valueOf(value);
            } else if (TRUE_PATTERN.matcher(value).matches()) {
                nvalue = 1;
            } else if (FALSE_PATTERN.matcher(value).matches()) {
                nvalue = 0;
            }
        }
        property.setValue(nvalue);
        return property;
    }

    @Override
    public BaseProperty newProperty() {
        IntegerProperty property = new IntegerProperty();
        property.setName(this.getName());
        return property;
    }

    @Override
    public void displayView(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        IntegerProperty prop = (IntegerProperty)object.safeget(name);
        if (prop == null) {
            return;
        }
        Integer iValue = (Integer)prop.getValue();
        if (iValue != null) {
            int value = iValue;
            buffer.append(this.getDisplayValue(context, value));
        }
    }

    private int getValue(String name, BaseCollection object) {
        Integer ivalue;
        IntegerProperty prop = (IntegerProperty)object.safeget(name);
        if (prop != null && (ivalue = (Integer)prop.getValue()) != null) {
            return ivalue;
        }
        return this.getDefaultValue();
    }

    @Override
    public void displayEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        String displayFormType = this.getDisplayFormType();
        if (this.getDisplayType().equals("checkbox")) {
            displayFormType = "checkbox";
        }
        if (displayFormType.equals("checkbox")) {
            this.displayCheckboxEdit(buffer, name, prefix, object, context);
        } else if (displayFormType.equals("select")) {
            this.displaySelectEdit(buffer, name, prefix, object, context);
        } else {
            this.displayRadioEdit(buffer, name, prefix, object, context);
        }
    }

    public void displaySelectEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        option[] options;
        select select2 = new select(prefix + name, 1);
        select2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        select2.setName(prefix + name);
        select2.setID(prefix + name);
        select2.setDisabled(this.isDisabled());
        String String0 = this.getDisplayValue(context, 0);
        String String1 = this.getDisplayValue(context, 1);
        int nb1 = 1;
        int nb2 = 2;
        if (this.getDefaultValue() == -1) {
            options = new option[]{new option("---", ""), new option(String1, "1"), new option(String0, "0")};
            options[0].addElement("---");
            options[1].addElement(XMLUtils.escape((String)String1));
            options[2].addElement(XMLUtils.escape((String)String0));
        } else {
            options = new option[]{new option(String1, "1"), new option(String0, "0")};
            options[0].addElement(XMLUtils.escape((String)String1));
            options[1].addElement(XMLUtils.escape((String)String0));
            nb1 = 0;
            nb2 = 1;
        }
        for (option option2 : options) {
            option2.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        }
        int value = this.getValue(name, object);
        if (value == 1) {
            options[nb1].setSelected(true);
        } else if (value == 0) {
            options[nb2].setSelected(true);
        } else {
            options[0].setSelected(true);
        }
        select2.addElement(options);
        buffer.append(select2.toString());
    }

    public void displayRadioEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        String StringNone = this.getDisplayValue(context, 2);
        String StringTrue = this.getDisplayValue(context, 1);
        String StringFalse = this.getDisplayValue(context, 0);
        input radioNone = new input("radio", prefix + name, "");
        radioNone.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        input radioTrue = new input("radio", prefix + name, "1");
        radioTrue.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        input radioFalse = new input("radio", prefix + name, "0");
        radioFalse.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        radioNone.setDisabled(this.isDisabled());
        radioTrue.setDisabled(this.isDisabled());
        radioFalse.setDisabled(this.isDisabled());
        label labelNone = new label();
        label labelTrue = new label();
        label labelFalse = new label();
        div divNone = new div();
        div divTrue = new div();
        div divFalse = new div();
        labelNone.addElement((Element)radioNone);
        labelNone.addElement(StringNone);
        divNone.addElement((Element)labelNone);
        labelTrue.addElement((Element)radioTrue);
        labelTrue.addElement(StringTrue);
        divTrue.addElement((Element)labelTrue);
        labelFalse.addElement((Element)radioFalse);
        labelFalse.addElement(StringFalse);
        divFalse.addElement((Element)labelFalse);
        radioNone.setID(prefix + name + "_none");
        labelNone.setFor(prefix + name + "_none");
        radioTrue.setID(prefix + name);
        labelTrue.setFor(prefix + name);
        radioFalse.setID(prefix + name + "_false");
        labelFalse.setFor(prefix + name + "_false");
        div[] inputs = this.getDefaultValue() == -1 ? new div[]{divNone, divTrue, divFalse} : new div[]{divTrue, divFalse};
        int value = this.getValue(name, object);
        if (value == 1) {
            radioTrue.setChecked(true);
        } else if (value == 0) {
            radioFalse.setChecked(true);
        } else {
            radioNone.setChecked(true);
        }
        for (div input2 : inputs) {
            buffer.append(input2.toString());
        }
    }

    public void displayCheckboxEdit(StringBuffer buffer, String name, String prefix, BaseCollection object, XWikiContext context) {
        input check = new input("checkbox", prefix + name, 1);
        check.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        check.setID(prefix + name);
        check.setDisabled(this.isDisabled());
        input checkNo = new input("hidden", prefix + name, 0);
        checkNo.setAttributeFilter((Filter)new XMLAttributeValueFilter());
        check.setChecked(this.getValue(name, object) == 1);
        buffer.append(check.toString());
        buffer.append(checkNo.toString());
    }

    private String getDisplayValue(XWikiContext context, int value) {
        try {
            String key = this.getFieldFullName() + "_" + value;
            Object result = this.localizePlain(key, new Object[0]);
            if (result == null && (result = this.localizePlain(key = this.getDisplayType() + "_" + value, new Object[0])) == null) {
                result = value == 2 ? "---" : "" + value;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "" + value;
        }
    }

    public /* synthetic */ String ajc$privMethod$com_xpn_xwiki_objects_classes_BooleanClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BooleanClass$getDisplayValue(XWikiContext xWikiContext, int n) {
        return this.getDisplayValue(xWikiContext, n);
    }

    public /* synthetic */ String ajc$superDispatch$com_xpn_xwiki_objects_classes_BooleanClass$getFullQueryPropertyName() {
        return super.getFullQueryPropertyName();
    }

    @Deprecated
    public String displayCheckboxSearch(String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return BooleanClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BooleanClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BooleanClass$displayCheckboxSearch(this, string, string2, xWikiCriteria, xWikiContext);
    }

    @Override
    @Deprecated
    public String displaySearch(String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return BooleanClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BooleanClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BooleanClass$displaySearch(this, string, string2, xWikiCriteria, xWikiContext);
    }

    @Deprecated
    public String displaySelectSearch(String string, String string2, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return BooleanClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BooleanClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BooleanClass$displaySelectSearch(this, string, string2, xWikiCriteria, xWikiContext);
    }

    @Override
    @Deprecated
    public void fromSearchMap(XWikiQuery xWikiQuery, Map<String, String[]> map) throws XWikiException {
        BooleanClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BooleanClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BooleanClass$fromSearchMap(this, xWikiQuery, map);
    }

    @Override
    @Deprecated
    public void makeQuery(Map<String, Object> map, String string, XWikiCriteria xWikiCriteria, List<String> list) {
        BooleanClassCompatibiityAspect.ajc$interMethod$com_xpn_xwiki_objects_classes_BooleanClassCompatibiityAspect$com_xpn_xwiki_objects_classes_BooleanClass$makeQuery(this, map, string, xWikiCriteria, list);
    }
}

