/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.objects.BaseProperty;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.util.ReflectionUtils;

public abstract class NumberProperty<N extends Number>
extends BaseProperty {
    private static final long serialVersionUID = 1L;
    private N value;
    private Class<N> numberClass;

    public NumberProperty() {
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(NumberProperty.class, this.getClass());
        this.numberClass = ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[0]);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        N number = this.convert(value);
        this.setValueDirty(value);
        this.value = number;
    }

    private N convert(Object value) {
        Number number = null;
        if (value != null) {
            if (this.numberClass == value.getClass()) {
                number = (Number)value;
            } else if (this.numberClass == Double.class) {
                number = value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : Double.valueOf(value.toString());
            } else if (this.numberClass == Float.class) {
                number = value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : Float.valueOf(value.toString());
            } else if (this.numberClass == Integer.class) {
                number = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(value.toString());
            } else if (this.numberClass == Long.class) {
                number = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(value.toString());
            }
        }
        return (N)number;
    }

    @Override
    public String toText() {
        Number nb = (Number)this.getValue();
        return nb == null ? "" : nb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.getValue(), ((NumberProperty)obj).getValue()).isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append(this.getValue());
        return builder.toHashCode();
    }

    @Override
    public NumberProperty<N> clone() {
        return (NumberProperty)super.clone();
    }

    @Override
    public NumberProperty<N> clone(boolean detach) {
        return (NumberProperty)super.clone(detach);
    }

    @Override
    protected void cloneInternal(BaseProperty clone) {
        NumberProperty property = (NumberProperty)clone;
        property.setValue(this.getValue());
    }
}

