/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.web.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.RegexEntityReference;

public class BaseObjectReference
extends ObjectReference {
    private static final long serialVersionUID = 1L;
    private static final Pattern NUMBERPATTERN = Pattern.compile("(\\\\*)\\[(\\d*)\\]$");
    protected DocumentReference xclassReference;
    protected Integer objectNumber;
    private boolean nameParsed;

    public BaseObjectReference(EntityReference reference) {
        super(reference);
    }

    public BaseObjectReference(DocumentReference classReference, Integer objectNumber, DocumentReference parent) {
        this((EntityReference)classReference, objectNumber, parent);
    }

    public BaseObjectReference(EntityReference classReference, Integer objectNumber, DocumentReference parent) {
        super(BaseObjectReference.toName(classReference, objectNumber, parent), parent);
        this.xclassReference = this.resolveClassReference(classReference);
        this.objectNumber = objectNumber;
        this.nameParsed = true;
    }

    public BaseObjectReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    public static RegexEntityReference any(String classReference) {
        return BaseObjectReference.any(classReference, null);
    }

    public static RegexEntityReference any(String classReference, EntityReference parent) {
        return new RegexEntityReference(Pattern.compile("([^:]*:)?" + Pattern.quote(classReference) + "\\[\\d*\\]"), EntityType.OBJECT, parent);
    }

    public static List<XObjectEvent> anyEvents(String classReference) {
        return Arrays.asList(new XObjectAddedEvent((EntityReference)BaseObjectReference.any(classReference)), new XObjectUpdatedEvent((EntityReference)BaseObjectReference.any(classReference)), new XObjectDeletedEvent((EntityReference)BaseObjectReference.any(classReference)));
    }

    private DocumentReference resolveClassReference(EntityReference classReference) {
        if (classReference instanceof DocumentReference) {
            return (DocumentReference)classReference;
        }
        return ((DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE)).resolve((Object)classReference, new Object[]{this.getParent()});
    }

    private static String toName(EntityReference classReference, Integer objectNumber, DocumentReference parent) {
        String name = (String)((EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki")).serialize(classReference, new Object[]{parent});
        if (objectNumber != null) {
            StringBuilder builder = new StringBuilder(name);
            builder.append('[');
            builder.append(objectNumber);
            builder.append(']');
            name = builder.toString();
        } else {
            Matcher matcher = NUMBERPATTERN.matcher(name);
            if (matcher.find() && matcher.group(1).length() % 2 == 0) {
                StringBuilder builder = new StringBuilder(name);
                builder.insert(matcher.start(), '\\');
                name = builder.toString();
            }
        }
        return name;
    }

    private void maybeParseName() {
        if (!this.nameParsed) {
            String objectNumberStr;
            String classReferenceStr;
            String name = this.getName();
            Matcher matcher = NUMBERPATTERN.matcher(name);
            if (matcher.find()) {
                if (matcher.group(1).length() % 2 == 0) {
                    classReferenceStr = name.substring(0, matcher.end(1));
                    objectNumberStr = matcher.group(2);
                } else {
                    classReferenceStr = name;
                    objectNumberStr = null;
                }
            } else {
                classReferenceStr = name;
                objectNumberStr = null;
            }
            this.xclassReference = ((DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING)).resolve((Object)classReferenceStr, new Object[]{this.getParent()});
            if (objectNumberStr != null) {
                this.objectNumber = Integer.valueOf(objectNumberStr);
            }
            this.nameParsed = true;
        }
    }

    public DocumentReference getXClassReference() {
        this.maybeParseName();
        return this.xclassReference;
    }

    public Integer getObjectNumber() {
        this.maybeParseName();
        return this.objectNumber;
    }

    public BaseObjectReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new BaseObjectReference((EntityReference)this, newParent);
    }
}

