/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseElement;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.ObjectInterface;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dom4j.Element;
import org.xwiki.evaluation.ObjectEvaluator;
import org.xwiki.evaluation.ObjectEvaluatorException;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;

public class BaseObject
extends BaseCollection<BaseObjectReference>
implements ObjectInterface,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String guid;
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;

    private DocumentReferenceResolver<String> getCurrentMixedDocumentReferenceResolver() {
        if (this.currentMixedDocumentReferenceResolver == null) {
            this.currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
        }
        return this.currentMixedDocumentReferenceResolver;
    }

    @Override
    @Deprecated
    public String getName() {
        return super.getName();
    }

    @Override
    @Deprecated
    public void setName(String name) {
        DocumentReference reference = this.getDocumentReference();
        if (reference != null) {
            EntityReference relativeReference = this.getRelativeEntityReferenceResolver().resolve((java.lang.Object)name, EntityType.DOCUMENT, new java.lang.Object[0]);
            reference = new DocumentReference(relativeReference.extractReference(EntityType.DOCUMENT).getName(), new SpaceReference(relativeReference.extractReference(EntityType.SPACE).getName(), reference.getParent().getParent()));
        } else {
            reference = this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)name, new java.lang.Object[0]);
        }
        this.setDocumentReference(reference);
    }

    @Override
    protected BaseObjectReference createReference() {
        BaseObjectReference reference = this.getXClassReference() != null && this.getDocumentReference() != null ? new BaseObjectReference(this.getXClassReference(), (Integer)this.getNumber(), this.getDocumentReference()) : null;
        return reference;
    }

    @Override
    public void setNumber(int number) {
        super.setNumber(number);
        this.referenceCache = null;
    }

    @Override
    public void setXClassReference(EntityReference xClassReference) {
        super.setXClassReference(xClassReference);
        this.referenceCache = null;
    }

    public void displayHidden(StringBuffer buffer, String name, String prefix, XWikiContext context) {
        ((PropertyClass)this.getXClass(context).get(name)).displayHidden(buffer, name, prefix, this, context);
    }

    public void displayView(StringBuffer buffer, String name, String prefix, XWikiContext context) {
        ((PropertyClass)this.getXClass(context).get(name)).displayView(buffer, name, prefix, this, context);
    }

    public void displayEdit(StringBuffer buffer, String name, String prefix, XWikiContext context) {
        ((PropertyClass)this.getXClass(context).get(name)).displayEdit(buffer, name, prefix, this, context);
    }

    public String displayHidden(String name, String prefix, XWikiContext context) {
        StringBuffer buffer = new StringBuffer();
        this.displayHidden(buffer, name, prefix, context);
        return buffer.toString();
    }

    public String displayView(String name, String prefix, XWikiContext context) {
        StringBuffer buffer = new StringBuffer();
        this.displayView(buffer, name, prefix, context);
        return buffer.toString();
    }

    public String displayEdit(String name, String prefix, XWikiContext context) {
        StringBuffer buffer = new StringBuffer();
        this.displayEdit(buffer, name, prefix, context);
        return buffer.toString();
    }

    public String displayHidden(String name, XWikiContext context) {
        return this.displayHidden(name, "", context);
    }

    public String displayView(String name, XWikiContext context) {
        return this.displayView(name, "", context);
    }

    public String displayEdit(String name, XWikiContext context) {
        return this.displayEdit(name, "", context);
    }

    @Override
    public BaseObject clone() {
        return (BaseObject)super.clone();
    }

    public BaseObject clone(boolean detach) {
        return (BaseObject)super.clone(detach);
    }

    @Override
    protected void cloneContent(BaseElement<BaseObjectReference> element) {
        super.cloneContent(element);
        BaseObject object = (BaseObject)element;
        object.setGuid(this.guid);
    }

    public BaseObject duplicate() {
        BaseObject object = this.clone();
        object.setGuid(null);
        return object;
    }

    public BaseObject duplicate(DocumentReference documentReference) {
        BaseObject object = this.duplicate();
        object.setDocumentReference(documentReference);
        return object;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getNumber() == ((BaseObject)obj).getNumber();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append(this.getNumber());
        return builder.toHashCode();
    }

    @Override
    public void fromXML(Element oel) throws XWikiException {
        super.fromXML(oel);
    }

    @Override
    public List<ObjectDiff> getDiff(java.lang.Object oldEntity, XWikiContext context) {
        String propertyType;
        PropertyClass pclass;
        BaseClass bclass;
        BaseProperty oldProperty;
        BaseProperty newProperty;
        ArrayList<ObjectDiff> difflist = new ArrayList<ObjectDiff>();
        BaseObject oldObject = (BaseObject)oldEntity;
        for (String propertyName : this.getPropertyList()) {
            String newPropertyValue;
            newProperty = (BaseProperty)this.getField(propertyName);
            oldProperty = (BaseProperty)oldObject.getField(propertyName);
            bclass = this.getXClass(context);
            pclass = (PropertyClass)(bclass == null ? null : bclass.getField(propertyName));
            String string = propertyType = pclass == null ? "" : pclass.getClassType();
            if (oldProperty == null) {
                if (newProperty == null || newProperty.toText().equals("")) continue;
                newPropertyValue = newProperty.getValue() instanceof String || pclass == null ? newProperty.toText() : pclass.displayView(propertyName, this, context);
                difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), this.getGuid(), "added", propertyName, propertyType, (java.lang.Object)"", (java.lang.Object)newPropertyValue));
                continue;
            }
            if (oldProperty.toText().equals(newProperty == null ? "" : newProperty.toText())) continue;
            if (pclass != null) {
                newPropertyValue = newProperty.getValue() instanceof String ? newProperty.toText() : pclass.displayView(propertyName, this, context);
                String oldPropertyValue = oldProperty.getValue() instanceof String ? oldProperty.toText() : pclass.displayView(propertyName, oldObject, context);
                difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), this.getGuid(), "changed", propertyName, propertyType, (java.lang.Object)oldPropertyValue, (java.lang.Object)newPropertyValue));
                continue;
            }
            difflist.add(new ObjectDiff(this.getXClassReference(), this.getNumber(), this.getGuid(), "changed", propertyName, propertyType, (java.lang.Object)oldProperty.toText(), (java.lang.Object)newProperty.toText()));
        }
        for (String propertyName : oldObject.getPropertyList()) {
            newProperty = (BaseProperty)this.getField(propertyName);
            oldProperty = (BaseProperty)oldObject.getField(propertyName);
            bclass = this.getXClass(context);
            if (bclass == null) {
                bclass = oldObject.getXClass(context);
            }
            pclass = (PropertyClass)(bclass == null ? null : bclass.getField(propertyName));
            String string = propertyType = pclass == null ? "" : pclass.getClassType();
            if (newProperty != null || oldProperty == null || oldProperty.toText().equals("")) continue;
            if (pclass != null) {
                String oldPropertyValue = oldProperty.getValue() instanceof String ? oldProperty.toText() : pclass.displayView(propertyName, oldObject, context);
                difflist.add(new ObjectDiff(oldObject.getXClassReference(), oldObject.getNumber(), oldObject.getGuid(), "removed", propertyName, propertyType, (java.lang.Object)oldPropertyValue, (java.lang.Object)""));
                continue;
            }
            difflist.add(new ObjectDiff(oldObject.getXClassReference(), oldObject.getNumber(), oldObject.getGuid(), "removed", propertyName, propertyType, (java.lang.Object)oldProperty.toText(), (java.lang.Object)""));
        }
        return difflist;
    }

    public Object newObjectApi(BaseObject obj, XWikiContext context) {
        return new Object(obj, context);
    }

    public void set(String fieldname, java.lang.Object value, XWikiContext context) throws XWikiException {
        BaseClass bclass = this.getXClass(context);
        PropertyClass pclass = (PropertyClass)bclass.get(fieldname);
        BaseProperty prop = (BaseProperty)this.safeget(fieldname);
        if (value instanceof String && pclass != null) {
            prop = pclass.fromString((String)value);
        } else {
            if (prop == null && pclass != null) {
                prop = pclass.newProperty();
            }
            if (prop != null) {
                prop.setValue(value);
            }
        }
        if (prop != null) {
            prop.setOwnerDocument(this.getOwnerDocument());
            this.safeput(fieldname, prop);
        }
    }

    public String getGuid() {
        if (this.guid == null) {
            return this.generateGuid();
        }
        return this.guid;
    }

    private synchronized String generateGuid() {
        if (this.guid == null) {
            this.guid = UUID.randomUUID().toString();
        }
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public void setOwnerDocument(XWikiDocument ownerDocument) {
        if (this.ownerDocument != ownerDocument) {
            super.setOwnerDocument(ownerDocument);
            if (this.ownerDocument != null) {
                this.setDocumentReference(this.ownerDocument.getDocumentReference());
            }
        }
    }

    @Override
    protected void mergeField(PropertyInterface currentElement, ElementInterface previousElement, ElementInterface newElement, MergeConfiguration configuration, XWikiContext context, MergeResult mergeResult) {
        PropertyClass propertyClass;
        BaseClass baseClass = this.getXClass(context);
        if (baseClass != null && (propertyClass = (PropertyClass)baseClass.get(currentElement.getName())) != null) {
            try {
                propertyClass.mergeProperty((BaseProperty)currentElement, (BaseProperty)previousElement, (BaseProperty)newElement, configuration, context, mergeResult);
            }
            catch (Exception e) {
                mergeResult.getLog().error("Failed to merge field [{}]", (java.lang.Object)currentElement.getName(), (java.lang.Object)e);
            }
            return;
        }
        super.mergeField(currentElement, previousElement, newElement, configuration, context, mergeResult);
    }

    public Map<String, String> evaluate() throws ObjectEvaluatorException {
        ObjectEvaluator objectEvaluator = Utils.getComponent(ObjectEvaluator.class);
        return objectEvaluator.evaluate(this);
    }
}

