/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;

public class XMLWriter
extends org.dom4j.io.XMLWriter {
    protected Stack<Element> parent = new Stack();
    private OutputStream out;

    protected XMLWriter() {
    }

    public XMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
        super(out, format);
        this.out = out;
    }

    public void writeDocumentStart(Document doc) throws IOException {
        this.writeDeclaration();
        if (doc.getDocType() != null) {
            this.indent();
            this.writeDocType(doc.getDocType());
        }
    }

    public void writeDocumentEnd(Document doc) throws IOException {
        if (!this.parent.isEmpty()) {
            this.writeClose((Element)this.parent.firstElement());
        }
        this.writePrintln();
        this.flush();
    }

    public void write(Element element, Reader rd) throws IOException {
        this.writeOpen(element);
        IOUtils.copy((Reader)rd, (Writer)this.writer);
        this.writeClose(element);
    }

    public void write(Element element, InputStream is) throws IOException {
        this.writeOpen(element);
        this.flush();
        IOUtils.copy((InputStream)is, (OutputStream)this.out);
        this.writeClose(element);
    }

    public void writeBase64(Element element, InputStream is) throws IOException {
        this.writeOpen(element);
        this.flush();
        try (Base64OutputStream base64 = new Base64OutputStream((OutputStream)new CloseShieldOutputStream(this.out));){
            IOUtils.copy((InputStream)is, (OutputStream)base64);
        }
        this.writeClose(element);
    }

    public void writeOpen(Element element) throws IOException {
        super.writeOpen(element);
        this.parent.push(element);
    }

    public void writeClose(Element element) throws IOException {
        while (this.parent.peek() != element) {
            super.writeClose(this.parent.pop());
        }
        super.writeClose(this.parent.pop());
    }
}

