/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.xml;

import com.xpn.xwiki.internal.xml.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DOMXMLWriter
extends XMLWriter {
    private Document doc;
    private OutputFormat format;

    public DOMXMLWriter(Document doc) {
        this(doc, DEFAULT_FORMAT);
    }

    public DOMXMLWriter(Document doc, OutputFormat format) {
        try {
            this.setOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to create DOMXMLWriter instance", e);
        }
        this.format = format;
        this.doc = doc;
    }

    @Override
    public void write(Element element, InputStream is) throws IOException {
        element.addText(IOUtils.toString((InputStream)is, (String)this.format.getEncoding()));
        this.write(element);
    }

    @Override
    public void write(Element element, Reader rd) throws IOException {
        element.addText(IOUtils.toString((Reader)rd));
        this.write(element);
    }

    @Override
    public void writeBase64(Element element, InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Base64OutputStream out = new Base64OutputStream((OutputStream)baos, true, 0, null);
        IOUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
        element.addText(baos.toString(this.format.getEncoding()));
        this.write(element);
    }

    @Override
    public void writeDocumentEnd(Document doc) throws IOException {
        if (!this.parent.isEmpty()) {
            this.writeClose((Element)this.parent.firstElement());
        }
    }

    @Override
    public void writeDocumentStart(Document doc) throws IOException {
    }

    public void write(Element element) throws IOException {
        if (this.parent.isEmpty()) {
            this.doc.setRootElement((Element)element.clone());
        } else {
            ((Element)this.parent.peek()).add((Element)element.clone());
        }
    }

    @Override
    public void writeClose(Element element) throws IOException {
        try {
            while (this.parent.peek() != element) {
                this.parent.pop();
            }
            this.parent.pop();
        }
        catch (EmptyStackException e) {
            throw new IOException("FATAL: Closing a element that have never been opened");
        }
    }

    @Override
    public void writeOpen(Element element) throws IOException {
        if (this.parent.isEmpty()) {
            this.doc.setRootElement(element);
        } else {
            this.parent.add(element);
        }
        this.parent.push(element);
    }

    public void startCDATA() throws SAXException {
        throw new SAXUnsupportedException();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        throw new SAXUnsupportedException();
    }

    public void startEntity(String name) throws SAXException {
        throw new SAXUnsupportedException();
    }

    public void endCDATA() throws SAXException {
        throw new SAXUnsupportedException();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        throw new SAXUnsupportedException();
    }

    public void endEntity(String name) throws SAXException {
        throw new SAXUnsupportedException();
    }

    public class SAXUnsupportedException
    extends RuntimeException {
        public SAXUnsupportedException() {
            super("SAX api is not supported");
        }
    }
}

