/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.user;

import com.xpn.xwiki.user.impl.xwiki.MyPersistentLoginManager;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.securityfilter.authenticator.persistent.PersistentLoginManagerInterface;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.security.authentication.AuthenticationConfiguration;

@Component
@Singleton
public class MyPersistentLoginManagerProvider
implements Provider<PersistentLoginManagerInterface> {
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource config;
    @Inject
    private AuthenticationConfiguration authenticationConfiguration;

    public PersistentLoginManagerInterface get() {
        MyPersistentLoginManager persistentLoginManager = new MyPersistentLoginManager();
        this.setIfSpecified("cookieprefix", persistentLoginManager::setCookiePrefix);
        this.setIfSpecified("cookiepath", persistentLoginManager::setCookiePath);
        persistentLoginManager.setCookieDomains(this.authenticationConfiguration.getCookieDomains().toArray(new String[0]));
        this.setIfSpecified("cookielife", arg_0 -> ((MyPersistentLoginManager)persistentLoginManager).setCookieLife(arg_0));
        this.setIfSpecified("protection", arg_0 -> ((MyPersistentLoginManager)persistentLoginManager).setProtection(arg_0));
        this.setIfSpecified("useip", arg_0 -> ((MyPersistentLoginManager)persistentLoginManager).setUseIP(arg_0));
        this.setIfSpecified("encryptionalgorithm", arg_0 -> ((MyPersistentLoginManager)persistentLoginManager).setEncryptionAlgorithm(arg_0));
        this.setIfSpecified("encryptionmode", arg_0 -> ((MyPersistentLoginManager)persistentLoginManager).setEncryptionMode(arg_0));
        this.setIfSpecified("encryptionpadding", arg_0 -> ((MyPersistentLoginManager)persistentLoginManager).setEncryptionPadding(arg_0));
        persistentLoginManager.setValidationKey(this.authenticationConfiguration.getValidationKey());
        persistentLoginManager.setEncryptionKey(this.authenticationConfiguration.getEncryptionKey());
        return persistentLoginManager;
    }

    private void setIfSpecified(String property, Consumer<String> setter) {
        String value = (String)this.config.getProperty("xwiki.authentication." + property);
        if (value != null) {
            setter.accept(value);
        }
    }
}

