/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.template;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AbstractAttachmentEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyUpdatedEvent;
import com.xpn.xwiki.internal.skin.WikiSkinUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.template.event.TemplateDeletedEvent;
import org.xwiki.template.event.TemplateUpdatedEvent;

@Component
@Named(value="templates")
@Singleton
public class TemplateListener
extends AbstractEventListener {
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    private ObservationManager observation;

    public TemplateListener() {
        super("templates", new Event[]{new XObjectPropertyUpdatedEvent(), new XObjectPropertyDeletedEvent(), new AttachmentDeletedEvent(), new AttachmentUpdatedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        if (document.getXObject((EntityReference)WikiSkinUtils.SKINCLASS_REFERENCE) != null) {
            if (event instanceof AbstractAttachmentEvent) {
                AttachmentReference attachment = new AttachmentReference(((AbstractAttachmentEvent)event).getName(), document.getDocumentReference());
                String id = (String)this.referenceSerializer.serialize((EntityReference)attachment, new Object[0]);
                if (event instanceof AttachmentDeletedEvent) {
                    this.observation.notify((Event)new TemplateDeletedEvent(id), (Object)this);
                } else if (event instanceof AttachmentUpdatedEvent) {
                    this.observation.notify((Event)new TemplateUpdatedEvent(id), (Object)this);
                }
            } else if (event instanceof XObjectPropertyEvent) {
                String id = (String)this.referenceSerializer.serialize(((XObjectPropertyEvent)event).getReference(), new Object[0]);
                if (event instanceof XObjectPropertyDeletedEvent) {
                    this.observation.notify((Event)new TemplateDeletedEvent(id), (Object)this);
                } else if (event instanceof XObjectPropertyUpdatedEvent) {
                    this.observation.notify((Event)new TemplateUpdatedEvent(id), (Object)this);
                }
            }
        }
    }
}

