/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.template;

import com.xpn.xwiki.internal.template.VelocityTemplateEvaluator;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.block.AbstractBlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateContent;

@Component(roles={TemplateAsyncRenderer.class})
public class TemplateAsyncRenderer
extends AbstractBlockAsyncRenderer {
    @Inject
    private MacroContentParser parser;
    @Inject
    private VelocityTemplateEvaluator evaluator;
    @Inject
    private AsyncContext asyncContext;
    private Template template;
    private List<String> id;
    private boolean inline;
    private Syntax targetSyntax;
    private TemplateContent content;
    private boolean blockMode;

    Set<String> initialize(Template template, boolean inline, boolean blockMode) throws Exception {
        this.template = template;
        this.content = template.getContent();
        this.blockMode = blockMode;
        this.inline = inline;
        Syntax contextTargetSyntax = this.renderingContext.getTargetSyntax();
        this.targetSyntax = contextTargetSyntax != null ? contextTargetSyntax : Syntax.PLAIN_1_0;
        this.id = this.createId(new Object[]{"template", template.getId(), this.targetSyntax.toIdString(), inline});
        return this.content.getContextEntries();
    }

    public List<String> getId() {
        return this.id;
    }

    public boolean isAsyncAllowed() {
        return this.content.isAsyncAllowed();
    }

    public boolean isCacheAllowed() {
        return this.content.isCacheAllowed();
    }

    public boolean isInline() {
        return this.inline;
    }

    public Syntax getTargetSyntax() {
        return this.targetSyntax;
    }

    public BlockAsyncRendererResult render(boolean async, boolean cached) throws RenderingException {
        if (this.content.getDocumentReference() != null) {
            this.asyncContext.useEntity((EntityReference)this.content.getDocumentReference());
        }
        if (this.content.getSourceSyntax() != null) {
            return this.renderWiki(async, cached);
        }
        return this.renderVelocity(async, cached);
    }

    private BlockAsyncRendererResult renderWiki(boolean async, boolean cached) throws RenderingException {
        XDOM xdom;
        try {
            MacroTransformationContext mtc = new MacroTransformationContext();
            mtc.setSyntax(this.content.getSourceSyntax());
            xdom = this.parser.parse(this.content.getContent(), mtc, false, this.isInline());
            this.transform((Block)xdom);
        }
        catch (Exception e) {
            throw new RenderingException("Failed to execute template", (Throwable)e);
        }
        String resultString = null;
        if (async || !this.blockMode) {
            resultString = this.render((Block)xdom);
        }
        return new BlockAsyncRendererResult(resultString, (Block)xdom);
    }

    private BlockAsyncRendererResult renderVelocity(boolean async, boolean cached) throws RenderingException {
        String result = this.evaluateContent(this.template, this.content);
        XDOM xdom = cached || this.blockMode ? (StringUtils.isEmpty((CharSequence)result) ? new XDOM(Collections.emptyList()) : new XDOM(Arrays.asList(new RawBlock(result, this.content.getRawSyntax() != null ? this.content.getRawSyntax() : this.targetSyntax)))) : null;
        return new BlockAsyncRendererResult(result, (Block)xdom);
    }

    private void transform(Block block) throws TransformationException {
        TransformationContext transformationContext = new TransformationContext(block instanceof XDOM ? (XDOM)block : new XDOM(Arrays.asList(block)), this.renderingContext.getDefaultSyntax(), this.renderingContext.isRestricted());
        String tId = this.renderingContext.getTransformationId();
        if (tId == null) {
            tId = this.template.getId() != null ? this.template.getId() : "unknown namespace";
        }
        transformationContext.setId(tId);
        transformationContext.setTargetSyntax(this.targetSyntax);
        this.transform(block, transformationContext);
    }

    private String evaluateContent(Template template, TemplateContent content) throws RenderingException {
        StringWriter writer = new StringWriter();
        try {
            this.evaluator.evaluateContent(template, content, writer);
        }
        catch (Exception e) {
            throw new RenderingException("Failed to evaluate template with id [" + template.getId() + "]", (Throwable)e);
        }
        return ((Object)writer).toString();
    }
}

