/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.template;

import com.xpn.xwiki.internal.skin.AbstractSkinResource;
import com.xpn.xwiki.internal.skin.InternalSkinManager;
import com.xpn.xwiki.internal.skin.WikiResource;
import com.xpn.xwiki.internal.template.ClassloaderResource;
import com.xpn.xwiki.internal.template.StringResource;
import com.xpn.xwiki.internal.template.TemplateAsyncRenderer;
import com.xpn.xwiki.internal.template.TemplateContext;
import com.xpn.xwiki.internal.template.TemplateSkinResource;
import com.xpn.xwiki.internal.template.VelocityTemplateEvaluator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheControl;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.classloader.internal.ClassLoaderUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;
import org.xwiki.filter.input.ReaderInputSource;
import org.xwiki.filter.input.StringInputSource;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.properties.BeanManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.PropertyException;
import org.xwiki.properties.RawProperties;
import org.xwiki.properties.annotation.PropertyHidden;
import org.xwiki.properties.annotation.PropertyId;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.printer.WriterWikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.util.ErrorBlockGenerator;
import org.xwiki.skin.Resource;
import org.xwiki.skin.ResourceRepository;
import org.xwiki.skin.Skin;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateContent;
import org.xwiki.template.TemplateRequirement;
import org.xwiki.template.TemplateRequirementsException;

@Component(roles={InternalTemplateManager.class})
@Singleton
public class InternalTemplateManager
implements Initializable,
Disposable {
    public static final DocumentReference SUPERADMIN_REFERENCE = new DocumentReference("xwiki", "XWiki", "superadmin");
    private static final Pattern PROPERTY_LINE = Pattern.compile("^##!(.+)=(.*)$\r?\n?", 8);
    private static final String TEMPLATE_RESOURCE_SUFFIX = "/templates/";
    private static final String PROPERTY_REQUIRE_PREFIX = "require.";
    @Inject
    private Environment environment;
    @Inject
    private ContentParser parser;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainRenderer;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikicfg;
    @Inject
    @Named(value="all")
    private ConfigurationSource allConfiguration;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    @Inject
    private BeanManager beanManager;
    @Inject
    private ConverterManager converter;
    @Inject
    private InternalSkinManager skins;
    @Inject
    private JobProgressManager progress;
    @Inject
    private Provider<TemplateAsyncRenderer> rendererProvider;
    @Inject
    private BlockAsyncRendererExecutor asyncExecutor;
    @Inject
    private TemplateContext templateContext;
    @Inject
    private VelocityTemplateEvaluator evaluator;
    @Inject
    private Provider<ErrorBlockGenerator> errorBlockGeneratorProvider;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private CacheControl cacheControl;
    @Inject
    private Logger logger;
    private String templateRootURL;
    private Cache<Template> templateCache;

    public void initialize() throws InitializationException {
        this.getTemplateRootPath();
        try {
            this.templateCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("templates", 500));
        }
        catch (CacheException e) {
            this.logger.error("Failed to create the filesystem template cache", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.templateCache != null) {
            this.templateCache.dispose();
        }
    }

    private void checkRequirements(Template template) throws Exception {
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        ArrayList<Exception> causes = null;
        TemplateContent templateContent = template.getContent();
        for (String propertyName : templateContent.getPropertyNames()) {
            if (!propertyName.startsWith(PROPERTY_REQUIRE_PREFIX)) continue;
            String requirementKey = propertyName.substring(PROPERTY_REQUIRE_PREFIX.length());
            if (componentManager.hasComponent(TemplateRequirement.class, requirementKey)) {
                try {
                    TemplateRequirement requirement = (TemplateRequirement)componentManager.getInstance(TemplateRequirement.class, requirementKey);
                    requirement.checkRequirement(requirementKey, (String)templateContent.getProperty(propertyName, (Object)null), template);
                }
                catch (Exception e) {
                    if (causes == null) {
                        causes = new ArrayList<Exception>();
                    }
                    causes.add(e);
                }
                continue;
            }
            this.logger.warn("No template requirement handler could be found for key [{}] in template [{}]", (Object)propertyName, (Object)template.getId());
        }
        if (causes != null) {
            throw new TemplateRequirementsException(template.getId(), causes);
        }
    }

    private String getTemplateRootPath() {
        URL url;
        if (this.templateRootURL == null && (url = this.environment.getResource(TEMPLATE_RESOURCE_SUFFIX)) != null) {
            this.templateRootURL = url.toString();
        }
        return this.templateRootURL;
    }

    private boolean checkFilesystemTemplate(String templatePath, boolean checkPathTraversal) {
        String templateURLString;
        String rootTemplate;
        URL templateURL = this.environment.getResource(templatePath);
        if (templateURL == null) {
            return false;
        }
        if (checkPathTraversal && (rootTemplate = this.getTemplateRootPath()) != null && !(templateURLString = templateURL.toString()).startsWith(this.getTemplateRootPath())) {
            this.logger.warn("Direct access to template file [{}] refused. Possible break-in attempt!", (Object)templateURLString);
            return false;
        }
        return true;
    }

    private void renderError(Throwable throwable, boolean inline, Writer writer) {
        Block block = this.generateError(throwable, inline);
        this.render(block, writer);
    }

    private Block generateError(Throwable throwable, boolean inline) {
        List errorBlocks = throwable instanceof TemplateRequirementsException ? ((ErrorBlockGenerator)this.errorBlockGeneratorProvider.get()).generateErrorBlocks(inline, "template.error.requirement", throwable.getMessage(), null, new Object[]{throwable}) : ((ErrorBlockGenerator)this.errorBlockGeneratorProvider.get()).generateErrorBlocks(inline, null, "Failed to execute template", null, new Object[]{throwable});
        if (inline) {
            if (errorBlocks.size() == 1) {
                return (Block)errorBlocks.get(0);
            }
            return new CompositeBlock(errorBlocks);
        }
        return new XDOM(errorBlocks);
    }

    public XDOM getXDOMNoException(String templateName) {
        XDOM xdom;
        try {
            xdom = this.getXDOM(templateName);
        }
        catch (Throwable e) {
            this.logger.error("Error while getting template [{}] XDOM", (Object)templateName, (Object)e);
            xdom = (XDOM)this.generateError(e, false);
        }
        return xdom;
    }

    public XDOM getXDOMNoException(Template template) {
        XDOM xdom;
        try {
            xdom = this.getXDOM(template);
        }
        catch (Throwable e) {
            this.logger.error("Error while getting template [{}] XDOM", (Object)template.getId(), (Object)e);
            xdom = (XDOM)this.generateError(e, false);
        }
        return xdom;
    }

    public XDOM getXDOM(Template template) throws Exception {
        XDOM xdom = template != null ? this.getXDOM(template, template.getContent()) : new XDOM(Collections.emptyList());
        return xdom;
    }

    private XDOM getXDOM(Template template, TemplateContent content) throws Exception {
        String result;
        XDOM xdom = content.getSourceSyntax() != null ? this.parser.parse(content.getContent(), content.getSourceSyntax()) : (StringUtils.isEmpty((CharSequence)(result = this.evaluateContent(template, content))) ? new XDOM(Collections.emptyList()) : new XDOM(Arrays.asList(new RawBlock(result, content.getRawSyntax() != null ? content.getRawSyntax() : this.renderingContext.getTargetSyntax()))));
        return xdom;
    }

    public XDOM getXDOM(String templateName) throws Exception {
        Template template = this.getTemplate(templateName);
        return this.getXDOM(template);
    }

    public String renderNoException(String template, boolean inline) {
        StringWriter writer = new StringWriter();
        this.renderNoException(template, inline, (Writer)writer);
        return ((Object)writer).toString();
    }

    public void renderNoException(String templateName, boolean inline, Writer writer) {
        try {
            this.render(templateName, inline, writer);
        }
        catch (Exception e) {
            this.logger.error("Error while rendering template [{}]", (Object)templateName, (Object)e);
            this.renderError(e, inline, writer);
        }
    }

    public void renderNoException(Template template, boolean inline, Writer writer) {
        try {
            this.render(template, inline, writer);
        }
        catch (Exception e) {
            this.logger.error("Error while rendering template [{}]", (Object)template, (Object)e);
            this.renderError(e, inline, writer);
        }
    }

    public String render(String templateName, boolean inline) throws Exception {
        return this.renderFromSkin(templateName, (Skin)null, inline);
    }

    public String renderFromSkin(String templateName, String skinId, boolean inline) throws Exception {
        Skin skin = this.skins.getSkin(skinId);
        return skin != null ? this.renderFromSkin(templateName, skin, inline) : null;
    }

    public String renderFromSkin(String templateName, Skin skin, boolean inline) throws Exception {
        StringWriter writer = new StringWriter();
        this.renderFromSkin(templateName, (ResourceRepository)skin, inline, writer);
        return ((Object)writer).toString();
    }

    public void render(String templateName, boolean inline, Writer writer) throws Exception {
        this.renderFromSkin(templateName, null, inline, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderFromSkin(String templateName, ResourceRepository repository, boolean inline, Writer writer) throws Exception {
        this.progress.startStep((Object)templateName, "template.render.message", "Render template [{}]", new Object[]{templateName});
        try {
            Template template;
            Template template2 = template = repository != null ? this.getTemplate(templateName, repository) : this.getTemplate(templateName);
            if (template != null) {
                this.render(template, inline, writer);
            }
        }
        finally {
            this.progress.endStep((Object)templateName);
        }
    }

    private AsyncRendererConfiguration configure(TemplateAsyncRenderer renderer, Template template, boolean inline, boolean blockMode) throws Exception {
        Set<String> contextEntries = renderer.initialize(template, inline, blockMode);
        AsyncRendererConfiguration configuration = new AsyncRendererConfiguration();
        configuration.setContextEntries(contextEntries);
        TemplateContent templateContent = template.getContent();
        if (templateContent.isAuthorProvided()) {
            configuration.setSecureReference(templateContent.getDocumentReference(), templateContent.getAuthorReference());
        }
        return configuration;
    }

    public void render(Template template, boolean inline, Writer writer) throws Exception {
        if (!this.shouldExecute(template)) {
            return;
        }
        this.checkRequirements(template);
        TemplateAsyncRenderer renderer = (TemplateAsyncRenderer)((Object)this.rendererProvider.get());
        AsyncRendererConfiguration configuration = this.configure(renderer, template, inline, false);
        String result = this.asyncExecutor.render((BlockAsyncRenderer)renderer, configuration);
        writer.append(result);
    }

    private boolean shouldExecute(Template template) throws Exception {
        return template != null && (template.getContent().getUnique() == null || !this.templateContext.isExecuted(template));
    }

    private void render(Block block, Writer writer) {
        BlockRenderer blockRenderer;
        WriterWikiPrinter printer = new WriterWikiPrinter(writer);
        try {
            blockRenderer = (BlockRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(BlockRenderer.class, this.getTargetSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            blockRenderer = this.plainRenderer;
        }
        blockRenderer.render(block, (WikiPrinter)printer);
    }

    public Block executeNoException(String templateName, boolean inline) {
        Block block;
        try {
            block = this.execute(templateName, inline);
        }
        catch (Throwable e) {
            this.logger.error("Error while executing template [{}]", (Object)templateName, (Object)e);
            block = this.generateError(e, inline);
        }
        return block;
    }

    public Block executeNoException(Template template, boolean inline) {
        Block block;
        try {
            block = this.execute(template, inline);
        }
        catch (Throwable e) {
            this.logger.error("Error while executing template [{}]", (Object)template.getId(), (Object)e);
            block = this.generateError(e, inline);
        }
        return block;
    }

    public Block execute(String templateName, boolean inline) throws Exception {
        Template template = this.getTemplate(templateName);
        return this.execute(template, inline);
    }

    public Block execute(Template template, boolean inline) throws Exception {
        if (!this.shouldExecute(template)) {
            return new XDOM(Collections.emptyList());
        }
        this.checkRequirements(template);
        TemplateAsyncRenderer renderer = (TemplateAsyncRenderer)((Object)this.rendererProvider.get());
        AsyncRendererConfiguration configuration = this.configure(renderer, template, inline, true);
        Block block = this.asyncExecutor.execute((BlockAsyncRenderer)renderer, configuration);
        if (inline) {
            return block;
        }
        return block instanceof XDOM ? block : new XDOM(Collections.singletonList(block));
    }

    private String evaluateContent(Template template, TemplateContent content) throws Exception {
        StringWriter writer = new StringWriter();
        this.evaluator.evaluateContent(template, content, writer);
        return ((Object)writer).toString();
    }

    private Syntax getTargetSyntax() {
        Syntax targetSyntax = this.renderingContext.getTargetSyntax();
        return targetSyntax != null ? targetSyntax : Syntax.PLAIN_1_0;
    }

    private Template getFileSystemTemplate(String templateName) {
        String templatePath = TEMPLATE_RESOURCE_SUFFIX + templateName;
        String templateId = TemplateSkinResource.createId(templatePath);
        Template template = this.getCachedTemplate(templateId);
        if (template != null) {
            if (!this.checkFilesystemTemplate(templatePath, false)) {
                this.templateCache.remove(templateId);
                return null;
            }
        } else if (!this.checkFilesystemTemplate(templatePath, true)) {
            return null;
        }
        if ((template = this.getCachedTemplate(templateId, template, () -> InternalTemplateManager.getResourceInstant(this.environment, templatePath))) == null) {
            template = new EnvironmentTemplate(new TemplateSkinResource(templatePath, templateName, this.environment));
            this.setCachedTemplate(templateId, template);
        }
        return template;
    }

    private Template getTemplate(Resource<?> resource) {
        Template template = this.getCachedTemplate(resource.getId(), null, () -> resource.getInstant());
        if (template == null) {
            template = resource instanceof AbstractSkinResource ? new EnvironmentTemplate((AbstractSkinResource)resource) : new DefaultTemplate(resource);
            this.setCachedTemplate(resource.getId(), template);
        }
        return template;
    }

    private Template getCachedTemplate(String id) {
        if (this.templateCache != null) {
            return (Template)this.templateCache.get(id);
        }
        return null;
    }

    private void setCachedTemplate(String id, Template template) {
        if (this.templateCache != null) {
            this.templateCache.set(id, (Object)template);
        }
    }

    private Template getCachedTemplate(String id, Template cachedTemplate, Callable<Instant> resourceInstantProvider) {
        Template template = cachedTemplate;
        if (this.templateCache != null) {
            if (template == null) {
                template = (Template)this.templateCache.get(id);
            }
            if (template != null) {
                Instant instant = template.getInstant();
                try {
                    if (instant != null && instant.isBefore(resourceInstantProvider.call())) {
                        template = null;
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Failed to get the instant for resource with idenfier [{}]: {}", (Object)id, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            if (template != null) {
                Instant templateInstant = template.getInstant();
                if (templateInstant != null) {
                    if (!this.cacheControl.isCacheReadAllowed(Date.from(templateInstant))) {
                        template = null;
                    }
                } else if (this.cacheControl.isCacheReadAllowed()) {
                    template = null;
                }
            }
        }
        return template;
    }

    private Template getClassloaderTemplate(String prefixPath, String templateName) {
        return this.getClassloaderTemplate(Thread.currentThread().getContextClassLoader(), prefixPath, templateName);
    }

    private Template getClassloaderTemplate(ClassLoader classloader, String prefixPath, String templateName) {
        URL url;
        try {
            url = ClassLoaderUtils.getResource((ClassLoader)classloader, (String)prefixPath, (String)templateName);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("The template name [{}] is trying to execute a path traversal attack!", (Object)templateName);
            return null;
        }
        return url != null ? new ClassloaderTemplate(new ClassloaderResource(url, templateName)) : null;
    }

    public Template getResourceTemplate(String templateName, ResourceRepository repository) {
        Resource resource = repository.getLocalResource(templateName);
        if (resource != null) {
            return this.getTemplate(resource);
        }
        return null;
    }

    public Template getTemplate(String templateName, ResourceRepository repository) {
        Resource resource = repository.getResource(templateName);
        if (resource != null) {
            return this.getTemplate(resource);
        }
        return null;
    }

    public Template getSkinTemplate(String templateName) {
        Skin baseSkin;
        Template template = null;
        Skin skin = this.skins.getCurrentSkin(false);
        if (skin != null) {
            template = this.getTemplate(templateName, (ResourceRepository)skin);
        }
        if (skin == null && (baseSkin = this.skins.getCurrentParentSkin(false)) != null) {
            template = this.getTemplate(templateName, (ResourceRepository)baseSkin);
        }
        return template;
    }

    public Template getTemplate(String templateName) {
        Skin baseSkin;
        Template template = null;
        Skin skin = this.skins.getCurrentSkin(false);
        if (skin != null) {
            template = this.getTemplate(templateName, (ResourceRepository)skin);
        }
        if (skin == null && (baseSkin = this.skins.getCurrentParentSkin(false)) != null) {
            template = this.getTemplate(templateName, (ResourceRepository)baseSkin);
        }
        if (template == null) {
            template = this.getFileSystemTemplate(templateName);
        }
        if (template == null) {
            template = this.getClassloaderTemplate("templates/", templateName);
        }
        return template;
    }

    public Template createStringTemplate(String id, String content, DocumentReference author, DocumentReference sourceReference) throws Exception {
        return new StringTemplate(id, content, author, sourceReference);
    }

    public static Instant getResourceInstant(Environment environment, String path) throws URISyntaxException, IOException {
        URL resourceUrl = environment.getResource(path);
        Path resourcePath = Paths.get(resourceUrl.toURI());
        FileTime lastModifiedTime = Files.getLastModifiedTime(resourcePath, new LinkOption[0]);
        return lastModifiedTime.toInstant();
    }

    private class EnvironmentTemplate
    extends AbtractTemplate<FilesystemTemplateContent, AbstractSkinResource> {
        EnvironmentTemplate(AbstractSkinResource resource) {
            super(resource);
        }

        @Override
        protected FilesystemTemplateContent getContentInternal(String content) {
            return new FilesystemTemplateContent(content);
        }
    }

    private class DefaultTemplate
    extends AbtractTemplate<DefaultTemplateContent, Resource<?>> {
        DefaultTemplate(Resource<?> resource) {
            super(resource);
        }

        @Override
        protected DefaultTemplateContent getContentInternal(String content) {
            if (this.resource instanceof WikiResource) {
                WikiResource wikiResource = (WikiResource)this.resource;
                return new DefaultTemplateContent(content, wikiResource.getAuthorReference(), wikiResource.getDocumentReference());
            }
            return new DefaultTemplateContent(content);
        }
    }

    private class ClassloaderTemplate
    extends AbtractTemplate<FilesystemTemplateContent, ClassloaderResource> {
        ClassloaderTemplate(ClassloaderResource resource) {
            super(resource);
        }

        @Override
        protected FilesystemTemplateContent getContentInternal(String content) {
            return new FilesystemTemplateContent(content);
        }
    }

    private class StringTemplate
    extends DefaultTemplate {
        StringTemplate(String id, String content, DocumentReference authorReference, DocumentReference documentReference) throws Exception {
            super(new StringResource(id, content));
            ((DefaultTemplateContent)this.getContent()).setAuthorReference(authorReference);
            ((DefaultTemplateContent)this.getContent()).setDocumentReference(documentReference);
        }
    }

    private class FilesystemTemplateContent
    extends DefaultTemplateContent {
        public FilesystemTemplateContent(String content) {
            super(content);
            this.setPrivileged(true);
        }

        @Override
        public void setAuthorReference(DocumentReference authorReference) {
            super.setAuthorReference(authorReference);
        }

        public boolean isPrivileged() {
            return SUPERADMIN_REFERENCE.equals((Object)this.getAuthorReference());
        }

        public void setPrivileged(boolean privileged) {
            if (privileged) {
                this.setAuthorReference(SUPERADMIN_REFERENCE);
            } else {
                this.authorReference = null;
                this.authorProvided = false;
            }
        }
    }

    class DefaultTemplateContent
    implements RawProperties,
    TemplateContent {
        protected String content;
        protected boolean authorProvided;
        protected DocumentReference authorReference;
        protected DocumentReference documentReference;
        @PropertyId(value="source.syntax")
        public Syntax sourceSyntax;
        @PropertyId(value="raw.syntax")
        public Syntax rawSyntax;
        public boolean cacheAllowed;
        public boolean asyncAllowed;
        public Set<String> contextEntries;
        public TemplateContent.UniqueContext unique;
        protected Map<String, Object> properties = new HashMap<String, Object>();
        protected Object compiledContent;

        DefaultTemplateContent(String content) {
            this.content = content;
            this.init();
        }

        DefaultTemplateContent(String content, DocumentReference authorReference) {
            this(content);
            this.setAuthorReference(authorReference);
        }

        DefaultTemplateContent(String content, DocumentReference authorReference, DocumentReference sourceReference) {
            this(content, authorReference);
            this.setDocumentReference(sourceReference);
        }

        public Syntax getSourceSyntax() {
            return this.sourceSyntax;
        }

        public Syntax getRawSyntax() {
            return this.rawSyntax;
        }

        public boolean isAsyncAllowed() {
            return this.asyncAllowed;
        }

        public boolean isCacheAllowed() {
            return this.cacheAllowed;
        }

        public TemplateContent.UniqueContext getUnique() {
            return this.unique;
        }

        public Set<String> getContextEntries() {
            if (this.contextEntries == null) {
                return Collections.emptySet();
            }
            if (this.contextEntries instanceof AbstractSet) {
                this.contextEntries = Collections.unmodifiableSet(this.contextEntries);
            }
            return this.contextEntries;
        }

        public <T> T getProperty(String name, T def) {
            if (!this.properties.containsKey(name)) {
                return def;
            }
            if (def != null) {
                return this.getProperty(name, def.getClass());
            }
            return (T)this.properties.get(name);
        }

        public <T> T getProperty(String name, Type type) {
            return (T)InternalTemplateManager.this.converter.convert(type, this.properties.get(name));
        }

        public Collection<String> getPropertyNames() {
            return this.properties.keySet();
        }

        protected void init() {
            Matcher matcher = PROPERTY_LINE.matcher(this.content);
            int newContentIndex = 0;
            HashMap<String, String> map = new HashMap<String, String>();
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                map.put(key, value);
                newContentIndex = matcher.end();
            }
            if (newContentIndex > 0) {
                this.content = this.content.substring(newContentIndex);
            }
            try {
                InternalTemplateManager.this.beanManager.populate((Object)this, map);
            }
            catch (PropertyException e) {
                InternalTemplateManager.this.logger.error("Failed to populate properties of template", (Throwable)e);
            }
        }

        public String getContent() {
            return this.content;
        }

        @PropertyHidden
        public boolean isAuthorProvided() {
            return this.authorProvided;
        }

        @PropertyId(value="author")
        public DocumentReference getAuthorReference() {
            return this.authorReference;
        }

        protected void setAuthorReference(DocumentReference authorReference) {
            this.authorReference = authorReference;
            this.authorProvided = true;
        }

        public DocumentReference getDocumentReference() {
            return this.documentReference;
        }

        protected void setDocumentReference(DocumentReference documentReference) {
            this.documentReference = documentReference;
        }

        public void set(String propertyName, Object value) {
            this.properties.put(propertyName, value);
        }
    }

    private static abstract class AbtractTemplate<T extends TemplateContent, R extends Resource<?>>
    implements Template {
        protected R resource;
        protected T content;
        protected Instant instant;

        public AbtractTemplate(R resource) {
            this.resource = resource;
        }

        public String getId() {
            return this.resource.getId();
        }

        public String getPath() {
            return this.resource.getPath();
        }

        public TemplateContent getContent() throws Exception {
            Instant resourceInstant;
            if (this.content == null) {
                try {
                    this.instant = this.resource.getInstant();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.content = this.loadContent();
            } else if (this.instant != null && (resourceInstant = this.resource.getInstant()).isAfter(this.instant)) {
                this.instant = resourceInstant;
                this.content = this.loadContent();
            }
            return this.content;
        }

        protected T loadContent() throws Exception {
            String strinContent;
            block9: {
                try (InputSource source = this.resource.getInputSource();){
                    if (source instanceof StringInputSource) {
                        strinContent = source.toString();
                        break block9;
                    }
                    if (source instanceof ReaderInputSource) {
                        strinContent = IOUtils.toString((Reader)((ReaderInputSource)source).getReader());
                        break block9;
                    }
                    if (source instanceof InputStreamInputSource) {
                        strinContent = IOUtils.toString((InputStream)((InputStreamInputSource)source).getInputStream(), (Charset)StandardCharsets.UTF_8);
                        break block9;
                    }
                    T t = null;
                    return t;
                }
            }
            return this.getContentInternal(strinContent);
        }

        protected abstract T getContentInternal(String var1) throws Exception;

        public Instant getInstant() {
            return this.instant;
        }

        public String toString() {
            return this.resource.getId();
        }
    }
}

