/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store.hibernate.query;

import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.query.Query;
import org.xwiki.query.WrappingQuery;

public final class HqlQueryUtils {
    private static final String FROM = "from";
    private static final String WHERE = "where ";
    private static final String ORDER = "order";
    private static final String ORDER_BY = "order by";
    private static final String COMMA = ",";
    private static final Pattern LEGACY_ORDINAL_PARAMS_PATTERN = Pattern.compile("([=\\s,\\(<>])\\?([=\\s,\\)<>]|$)");
    private static final Set<String> VALID_ORDER = Set.of("asc", "desc");

    private HqlQueryUtils() {
    }

    public static boolean isShortFormStatement(String statement) {
        return StringUtils.startsWithAny((CharSequence)statement.trim().toLowerCase(), (CharSequence[])new CharSequence[]{COMMA, WHERE, ORDER_BY});
    }

    public static String replaceLegacyQueryParameters(String queryString) {
        String convertedString = queryString;
        int index = 1;
        Matcher matcher;
        while ((matcher = LEGACY_ORDINAL_PARAMS_PATTERN.matcher(convertedString)).find()) {
            StringBuilder builder = new StringBuilder();
            builder.append(convertedString, 0, matcher.end(1));
            builder.append('?');
            builder.append(index);
            builder.append(convertedString, matcher.start(2), convertedString.length());
            convertedString = builder.toString();
            ++index;
        }
        return convertedString;
    }

    public static String toCompleteStatement(String statement) {
        Object completeStatement = statement;
        if (StringUtils.isEmpty((CharSequence)statement) || HqlQueryUtils.isShortFormStatement(statement)) {
            completeStatement = "select doc.fullName from XWikiDocument doc " + statement.trim();
        }
        return completeStatement;
    }

    public static Query toCompleteQuery(Query query) {
        boolean isCompleted;
        Object completeQuery = query;
        final String completeStatement = HqlQueryUtils.toCompleteStatement(query.getStatement());
        boolean bl = isCompleted = completeStatement != query.getStatement();
        if (isCompleted) {
            completeQuery = new WrappingQuery(query){

                public String getStatement() {
                    return completeStatement;
                }
            };
        }
        return completeQuery;
    }

    public static String createLegacySQLQuery(String queryPrefix, String whereSQL) {
        StringBuilder sql = new StringBuilder(queryPrefix);
        String normalizedWhereSQL = StringUtils.isBlank((CharSequence)whereSQL) ? "" : whereSQL.trim();
        sql.append(HqlQueryUtils.getColumnsForSelectStatement(normalizedWhereSQL));
        sql.append(" from XWikiDocument as doc");
        if (!normalizedWhereSQL.equals("")) {
            if (!normalizedWhereSQL.startsWith(WHERE) && normalizedWhereSQL.charAt(0) != ',') {
                sql.append(" where ");
            } else {
                sql.append(" ");
            }
            sql.append(normalizedWhereSQL);
        }
        return sql.toString();
    }

    public static String getColumnsForSelectStatement(String whereSQL) {
        StringBuilder columns = new StringBuilder();
        int orderByPos = whereSQL.toLowerCase().indexOf(ORDER_BY);
        if (orderByPos >= 0) {
            String orderByStatement = whereSQL.substring(orderByPos + ORDER_BY.length() + 1);
            StringTokenizer tokenizer = new StringTokenizer(orderByStatement, COMMA);
            while (tokenizer.hasMoreTokens()) {
                String column = tokenizer.nextToken().trim();
                column = StringUtils.removeEndIgnoreCase((String)column, (String)" desc");
                column = StringUtils.removeEndIgnoreCase((String)column, (String)" asc");
                columns.append(", ").append(column.trim());
            }
        }
        return columns.toString();
    }

    public static String getValidQueryOrder(String order, String def) {
        if (order == null || !VALID_ORDER.contains(order.toLowerCase())) {
            return def;
        }
        return order;
    }
}

