/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store.hibernate.legacy;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.internal.store.hibernate.legacy.LegacyQueryImplementor;
import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import java.util.Collections;
import java.util.regex.Pattern;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.logging.LoggerConfiguration;

@Deprecated
public class LegacySessionImplementor
extends SessionDelegatorBaseImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWiki.class);
    private static final String LEGACY_ORDINAL_PARAMS_PREFIX = "Legacy-style query parameters (`?`) are no longer supported; use JPA-style ordinal parameters (e.g., `?1`) instead : %s".substring(0, 115);
    private static final Pattern LEGACY_MATCHER = Pattern.compile("\\?($|[^\\d])");
    private final LoggerConfiguration loggerConfiguration;

    public LegacySessionImplementor(SessionImplementor delegate, LoggerConfiguration loggerConfiguration) {
        super(delegate);
        this.loggerConfiguration = loggerConfiguration;
    }

    public static boolean containsLegacyOrdinalStatement(String statement) {
        return LEGACY_MATCHER.matcher(statement).find();
    }

    private String replaceLegacyQueryParameters(String queryString) {
        String convertedQueryString = HqlQueryUtils.replaceLegacyQueryParameters(queryString);
        if (this.loggerConfiguration.isDeprecatedLogEnabled()) {
            LOGGER.warn("Deprecated usage legacy-style HQL ordinal parameters (`?`); use JPA-style ordinal parameters (e.g., `?1`) instead. Query [{}] has been converted to [{}]", (Object)queryString, (Object)convertedQueryString);
        }
        return convertedQueryString;
    }

    private String checkStatement(String statement) {
        if (LegacySessionImplementor.containsLegacyOrdinalStatement(statement)) {
            try {
                this.getFactory().getQueryPlanCache().getHQLQueryPlan(statement, false, Collections.emptyMap());
            }
            catch (QueryException e) {
                if (e.getMessage() != null && e.getMessage().contains(LEGACY_ORDINAL_PARAMS_PREFIX)) {
                    return this.replaceLegacyQueryParameters(statement);
                }
                throw e;
            }
        }
        return null;
    }

    public QueryImplementor createQuery(String queryString) {
        String convertedStatement = this.checkStatement(queryString);
        if (convertedStatement != null) {
            return new LegacyQueryImplementor(super.createQuery(convertedStatement));
        }
        return super.createQuery(queryString);
    }

    public <T> QueryImplementor<T> createQuery(String queryString, Class<T> resultType) {
        String convertedStatement = this.checkStatement(queryString);
        if (convertedStatement != null) {
            return new LegacyQueryImplementor(super.createQuery(convertedStatement, resultType));
        }
        return super.createQuery(queryString, resultType);
    }
}

