/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store.hibernate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.hibernate.MappingException;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.cfg.Configuration;

public class HibernateStoreConfiguration
extends Configuration {
    private final MetadataSources metadataSources = new MetadataSources();

    public HibernateStoreConfiguration(URL url) {
        if (url != null) {
            this.configure(url);
        }
    }

    public Configuration addURL(URL url) throws MappingException {
        this.metadataSources.addURL(url);
        return super.addURL(url);
    }

    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray((InputStream)xmlInputStream);
        }
        catch (IOException e) {
            throw new MappingException("Failed to read the configuration file", (Throwable)e);
        }
        return this.addBytes(bytes);
    }

    public Configuration addResource(String resourceName) throws MappingException {
        this.metadataSources.addResource(resourceName);
        return super.addResource(resourceName);
    }

    private Configuration addBytes(byte[] bytes) {
        this.metadataSources.addInputStream((InputStream)new ByteArrayInputStream(bytes));
        return super.addInputStream((InputStream)new ByteArrayInputStream(bytes));
    }

    public void copy(MetadataSources metadataSource) {
        for (Binding binding : this.metadataSources.getXmlBindings()) {
            metadataSource.addXmlBinding(binding);
        }
    }
}

