/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.store.hibernate.DatabaseMetaDataFunction;
import com.xpn.xwiki.internal.store.hibernate.HibernateConfiguration;
import com.xpn.xwiki.internal.store.hibernate.HibernateStoreConfiguration;
import com.xpn.xwiki.internal.store.hibernate.ResultSetFunction;
import com.xpn.xwiki.internal.store.hibernate.legacy.LegacySessionImplementor;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.migration.DataMigrationManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.cfgxml.internal.ConfigLoader;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jdbc.Work;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.query.NativeQuery;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.DisposePriority;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.environment.Environment;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.store.hibernate.HibernateAdapter;
import org.xwiki.store.hibernate.HibernateAdapterFactory;
import org.xwiki.store.hibernate.HibernateStoreException;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component(roles={HibernateStore.class})
@Singleton
@DisposePriority(value=10000)
public class HibernateStore
implements Disposable,
Initializable {
    private static final String CONTEXT_SESSION = "hibsession";
    private static final String CONTEXT_TRANSACTION = "hibtransaction";
    private static final String PROPERTY_PERMANENTDIRECTORY = "environment.permanentDirectory";
    private static final String PROPERTY_TIMEZONE_VARIABLE = "${timezone}";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="hibernate")
    private Provider<DataMigrationManager> dataMigrationManagerProvider;
    @Inject
    private Execution execution;
    @Inject
    private HibernateConfiguration hibernateConfiguration;
    @Inject
    private Environment environment;
    @Inject
    private LoggerConfiguration loggerConfiguration;
    @Inject
    private List<HibernateAdapterFactory> adapterFactories;
    @Inject
    private WikiDescriptorManager wikis;
    @Inject
    private Provider<HibernateAdapter> defaultHibernateAdapterProvider;
    private DataMigrationManager dataMigrationManager;
    private MetadataSources metadataSources;
    private HibernateStoreConfiguration configuration;
    private BootstrapServiceRegistry bootstrapServiceRegistry;
    private StandardServiceRegistry standardRegistry;
    private Dialect dialect;
    private DatabaseProduct databaseProductCache = DatabaseProduct.UNKNOWN;
    private HibernateAdapter adapter;
    private SessionFactory sessionFactory;
    private Metadata configuredMetadata;
    private String configurationCatalog;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private URL configurationURL;

    private DataMigrationManager getDataMigrationManager() {
        if (this.dataMigrationManager == null) {
            this.dataMigrationManager = (DataMigrationManager)this.dataMigrationManagerProvider.get();
        }
        return this.dataMigrationManager;
    }

    private URL getHibernateConfigurationURL() {
        String path = this.hibernateConfiguration.getPath();
        if (path == null) {
            return null;
        }
        File file = new File(path);
        try {
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed load resource [{}] using a file path", (Object)path);
        }
        try {
            URL res = this.environment.getResource(path);
            if (res != null) {
                return res;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to load resource [{}] using the application context", (Object)path);
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null) {
            this.logger.error("Failed to find hibernate configuration file corresponding to path [{}]", (Object)this.hibernateConfiguration.getPath());
        }
        return url;
    }

    public void initialize() throws InitializationException {
        this.configurationURL = this.getHibernateConfigurationURL();
        this.configuration = new HibernateStoreConfiguration(this.configurationURL);
        this.replaceVariables(this.configuration);
    }

    private void disposeSessionFactory() {
        Session session = this.getCurrentSession();
        this.closeSession(session);
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        if (this.standardRegistry != null) {
            this.standardRegistry.close();
        }
        if (this.bootstrapServiceRegistry != null) {
            this.bootstrapServiceRegistry.close();
        }
        this.adapter = null;
    }

    private void createSessionFactory() {
        this.bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().build();
        ConfigLoader configLoader = new ConfigLoader(this.bootstrapServiceRegistry);
        LoadedConfig baseConfiguration = configLoader.loadConfigXmlUrl(this.configurationURL);
        this.replaceVariables(baseConfiguration);
        StandardServiceRegistryBuilder standardRegistryBuilder = new StandardServiceRegistryBuilder(this.bootstrapServiceRegistry);
        standardRegistryBuilder.configure(baseConfiguration);
        this.standardRegistry = standardRegistryBuilder.build();
        this.metadataSources = new MetadataSources((ServiceRegistry)this.standardRegistry);
        this.configuration.copy(this.metadataSources);
        MetadataBuilder metadataBuilder = this.metadataSources.getMetadataBuilder();
        this.configuredMetadata = metadataBuilder.build();
        Identifier catalog = this.configuredMetadata.getDatabase().getJdbcEnvironment().getCurrentCatalog();
        if (catalog != null) {
            this.configurationCatalog = catalog.getCanonicalName();
        }
        this.sessionFactory = this.configuredMetadata.getSessionFactoryBuilder().build();
    }

    public void initHibernate() {
        this.build();
    }

    private String resolveURL(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url) && url.matches(".*\\$\\{.*\\}.*")) {
            String newURL = StringUtils.replace((String)url, (String)String.format("${%s}", PROPERTY_PERMANENTDIRECTORY), (String)this.environment.getPermanentDirectory().getAbsolutePath());
            try {
                return StringUtils.replace((String)newURL, (String)PROPERTY_TIMEZONE_VARIABLE, (String)URLEncoder.encode(TimeZone.getDefault().getID(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Failedd to encode the current timezone id", (Throwable)e);
            }
        }
        return null;
    }

    private void replaceVariables(Configuration hibernateConfiguration) {
        String newURL = this.resolveURL(hibernateConfiguration.getProperty("hibernate.connection.url"));
        if (newURL != null) {
            hibernateConfiguration.setProperty("hibernate.connection.url", newURL);
            this.logger.debug("Resolved Hibernate URL [{}] to [{}]", (Object)newURL, (Object)newURL);
        }
    }

    private void replaceVariables(LoadedConfig hibernateConfiguration) {
        Map values = hibernateConfiguration.getConfigurationValues();
        String newURL = this.resolveURL((String)values.get("hibernate.connection.url"));
        if (newURL != null) {
            values.put("hibernate.connection.url", newURL);
            this.logger.debug("Resolved Hibernate URL [{}] to [{}]", (Object)newURL, (Object)newURL);
        }
    }

    public void build() {
        this.lock.writeLock().lock();
        try {
            if (this.sessionFactory != null) {
                this.disposeSessionFactory();
            }
            this.createSessionFactory();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.disposeSessionFactory();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DatabaseProduct getDatabaseProductName() {
        if (this.databaseProductCache == DatabaseProduct.UNKNOWN) {
            if (this.getSessionFactory() != null) {
                DatabaseMetaData metaData = this.getDatabaseMetaData();
                if (metaData != null) {
                    try {
                        this.databaseProductCache = DatabaseProduct.toProduct(metaData.getDatabaseProductName());
                    }
                    catch (SQLException sQLException) {}
                }
            } else {
                String connectionURL = this.configuration.getProperty("hibernate.connection.url");
                if (connectionURL == null) {
                    connectionURL = this.configuration.getProperty("connection.url");
                }
                this.databaseProductCache = DatabaseProduct.toProduct(this.extractJDBCConnectionURLScheme(connectionURL));
            }
        }
        return this.databaseProductCache;
    }

    public HibernateAdapter getAdapter() throws HibernateException {
        if (this.adapter == null) {
            this.adapter = this.createHibernateAdapter();
        }
        return this.adapter;
    }

    private synchronized HibernateAdapter createHibernateAdapter() {
        DatabaseMetaData metadata = this.getDatabaseMetaData();
        for (HibernateAdapterFactory factory : this.adapterFactories) {
            Optional<HibernateAdapter> newAdapter = factory.createHibernateAdapter(metadata, this.getConfiguration());
            if (!newAdapter.isPresent()) continue;
            return newAdapter.get();
        }
        return (HibernateAdapter)this.defaultHibernateAdapterProvider.get();
    }

    private String extractJDBCConnectionURLScheme(String fullConnectionURL) {
        return StringUtils.split((String)fullConnectionURL, (char)':')[1];
    }

    public DatabaseMetaData getDatabaseMetaData() {
        block17: {
            try (SessionImplementor session = (SessionImplementor)this.getSessionFactory().openSession();){
                DatabaseMetaData databaseMetaData;
                block16: {
                    JdbcConnectionAccess jdbcConnectionAccess = session.getJdbcConnectionAccess();
                    Connection connection = jdbcConnectionAccess.obtainConnection();
                    try {
                        databaseMetaData = connection.getMetaData();
                        if (connection == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException sQLException) {
                            if (session != null) {
                                session.close();
                            }
                            break block17;
                        }
                    }
                    connection.close();
                }
                return databaseMetaData;
            }
        }
        return null;
    }

    public Metadata getConfigurationMetadata() {
        return this.configuredMetadata;
    }

    public void setWiki(MetadataBuilder builder, String wikiId) {
        String databaseName = this.getAdapter().getDatabaseFromWikiName(wikiId);
        if (this.getAdapter().isCatalog()) {
            builder.applyImplicitCatalogName(databaseName);
        } else {
            builder.applyImplicitSchemaName(databaseName);
        }
    }

    public Metadata getMetadata(String className, String customMapping, String wikiId) {
        MetadataSources builder = new MetadataSources();
        builder.addInputStream((InputStream)new ByteArrayInputStream(this.makeMapping(className, customMapping).getBytes(StandardCharsets.UTF_8)));
        MetadataBuilder metadataBuilder = builder.getMetadataBuilder();
        if (wikiId != null) {
            this.setWiki(metadataBuilder, wikiId);
        }
        return metadataBuilder.build();
    }

    public String makeMapping(String className, String customMapping) {
        DatabaseProduct databaseProduct = this.getDatabaseProductName();
        return new StringBuilder(2000).append("<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n").append("<!DOCTYPE hibernate-mapping PUBLIC\n").append("\t\"-//Hibernate/Hibernate Mapping DTD//EN\"\n").append("\t\"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n").append("<hibernate-mapping>").append("<class entity-name=\"").append(className).append("\" table=\"").append(this.toDynamicMappingTableName(className)).append("\">\n").append(" <id name=\"id\" type=\"long\" unsaved-value=\"any\">\n").append("   <column name=\"XWO_ID\" not-null=\"true\" ").append(databaseProduct == DatabaseProduct.ORACLE ? "sql-type=\"integer\" " : "").append("/>\n   <generator class=\"assigned\" />\n").append(" </id>\n").append(customMapping).append("</class>\n</hibernate-mapping>").toString();
    }

    public String toDynamicMappingTableName(String className) {
        return "xwikicustom_" + className.replaceAll("\\.", "_");
    }

    public Dialect getDialect() {
        if (this.dialect == null) {
            JdbcServices jdbcServices = (JdbcServices)this.standardRegistry.getService(JdbcServices.class);
            this.dialect = jdbcServices.getDialect();
        }
        return this.dialect;
    }

    public void setWiki(Session session) throws XWikiException {
        this.setWiki(session, this.wikis.getCurrentWikiId());
    }

    public void setWiki(Session session, String wikiId) throws XWikiException {
        try {
            this.logger.debug("Set the right catalog in the session [{}]", (Object)wikiId);
            if (wikiId != null) {
                String databaseName = this.getAdapter().getDatabaseFromWikiName(wikiId);
                String escapedDatabaseName = this.getAdapter().escapeDatabaseName(databaseName);
                DatabaseProduct product = this.getDatabaseProductName();
                if (DatabaseProduct.ORACLE == product) {
                    this.executeStatement("alter session set current_schema = " + escapedDatabaseName, session);
                } else if (DatabaseProduct.DERBY == product || DatabaseProduct.HSQLDB == product || DatabaseProduct.DB2 == product || DatabaseProduct.H2 == product) {
                    this.executeStatement("SET SCHEMA " + escapedDatabaseName, session);
                } else if (DatabaseProduct.POSTGRESQL == product && this.getAdapter().isConfiguredInSchemaMode()) {
                    this.executeStatement("SET search_path TO " + escapedDatabaseName, session);
                } else {
                    session.doWork(connection -> {
                        String catalog = connection.getCatalog();
                        String string = catalog = catalog == null ? null : catalog.replace('_', '-');
                        if (!databaseName.equals(catalog)) {
                            connection.setCatalog(databaseName);
                        }
                    });
                }
                session.setProperty("xwiki.database", (Object)databaseName);
            }
        }
        catch (Exception e) {
            this.endTransaction(false);
            Object[] args = new Object[]{wikiId};
            throw new XWikiException(3, 3301, "Exception while switching to wiki {0}", e, args);
        }
    }

    public Session getCurrentSession() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            Session session = (Session)context.getProperty(CONTEXT_SESSION);
            try {
                if (session != null) {
                    session.setHibernateFlushMode(FlushMode.COMMIT);
                }
            }
            catch (SessionException ex) {
                session = null;
            }
            return session;
        }
        return null;
    }

    public void setCurrentSession(Session session) {
        ExecutionContext context = this.execution.getContext();
        if (session == null) {
            context.removeProperty(CONTEXT_SESSION);
        } else {
            context.setProperty(CONTEXT_SESSION, (Object)session);
        }
    }

    public Transaction getCurrentTransaction() {
        ExecutionContext context = this.execution.getContext();
        return (Transaction)context.getProperty(CONTEXT_TRANSACTION);
    }

    public void setCurrentTransaction(Transaction transaction) {
        ExecutionContext context = this.execution.getContext();
        if (transaction == null) {
            context.removeProperty(CONTEXT_TRANSACTION);
        } else {
            context.setProperty(CONTEXT_TRANSACTION, (Object)transaction);
        }
    }

    public boolean beginTransaction() throws XWikiException {
        return this.beginTransaction(null);
    }

    public boolean beginTransaction(SessionFactory sfactory) throws XWikiException {
        Transaction transaction = this.getCurrentTransaction();
        Object session = this.getCurrentSession();
        if (session == null && transaction != null || transaction == null && session != null) {
            this.logger.warn("Incompatible session ({}) and transaction ({}) status", session, (Object)transaction);
            return false;
        }
        String contextWikiId = this.wikis.getCurrentWikiId();
        if (session != null) {
            String contextDatabase;
            String sessionDatabase = (String)session.getProperties().get("xwiki.database");
            if (!Objects.equals(sessionDatabase, contextDatabase = this.getAdapter().getDatabaseFromWikiName(contextWikiId))) {
                Object[] args = new Object[]{contextWikiId};
                throw new XWikiException(3, 3301, "Cannot switch to database {0} in an existing session", null, args);
            }
            this.logger.debug("Taking session from context [{}]", session);
            this.logger.debug("Taking transaction from context [{}]", (Object)transaction);
            return false;
        }
        try {
            if (!this.wikis.isMainWiki(contextWikiId) && this.wikis.getById(contextWikiId) == null) {
                throw new XWikiException(0, 2, "No wiki with id [" + contextWikiId + "] could be found");
            }
        }
        catch (WikiManagerException e) {
            throw new XWikiException("Failed to load the wiki descriptor", e);
        }
        try {
            this.getDataMigrationManager().checkDatabase();
        }
        catch (Exception e) {
            throw new XWikiException(3, 3301, "Exception while initializing the database", e);
        }
        this.logger.debug("Trying to get session from pool");
        session = sfactory == null ? this.getSessionFactory().openSession() : sfactory.openSession();
        this.logger.debug("Taken session from pool [{}]", session);
        if (session instanceof SessionImplementor) {
            session = new LegacySessionImplementor((SessionImplementor)session, this.loggerConfiguration);
        }
        this.setCurrentSession((Session)session);
        this.logger.debug("Trying to open transaction");
        transaction = session.beginTransaction();
        this.logger.debug("Opened transaction [{}]", (Object)transaction);
        this.setCurrentTransaction(transaction);
        this.setWiki((Session)session);
        return true;
    }

    public SessionFactory getSessionFactory() {
        this.lock.readLock().lock();
        try {
            SessionFactory sessionFactory = this.sessionFactory;
            return sessionFactory;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void endTransaction(boolean commit) {
        Session session = null;
        try {
            session = this.getCurrentSession();
            Transaction transaction = this.getCurrentTransaction();
            this.setCurrentSession(null);
            this.setCurrentTransaction(null);
            if (transaction != null) {
                this.logger.debug("Releasing hibernate transaction [{}]", (Object)transaction);
                if (commit) {
                    if (transaction.getRollbackOnly()) {
                        throw new HibernateException("The transaction [" + String.valueOf(transaction) + "] has been unexpectedly marked as rollback only");
                    }
                    transaction.commit();
                } else {
                    transaction.rollback();
                }
            }
        }
        catch (HibernateException e) {
            throw new HibernateException("Failed to commit or rollback transaction. Root cause [" + this.getExceptionMessage(e) + "]", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private String getExceptionMessage(Throwable t) {
        StringBuilder sb = new StringBuilder();
        Throwable next = null;
        Throwable current = t;
        while (current != null) {
            next = current.getCause();
            if (next == current) {
                next = null;
            }
            if (current instanceof SQLException) {
                SQLException sx = (SQLException)current;
                while (sx.getNextException() != null) {
                    sx = sx.getNextException();
                    sb.append("\nSQL next exception = [" + String.valueOf(sx) + "]");
                }
            }
            current = next;
        }
        return sb.toString();
    }

    @Deprecated
    public void shutdownHibernate() {
        this.disposeSessionFactory();
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    private void executeStatement(final String sql, Session session) {
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                try (Statement stmt = connection.createStatement();){
                    stmt.execute(sql);
                }
            }
        });
    }

    public void updateDatabase(String wikiId) throws HibernateStoreException {
        MetadataBuilder metadataBuilder = this.metadataSources.getMetadataBuilder();
        this.setWiki(metadataBuilder, wikiId);
        this.getAdapter().updateDatabase(metadataBuilder.build());
        this.createSequenceIfMissing(wikiId);
    }

    private <T, E> T executeNative(String sqlString, Function<NativeQuery<E>, T> function) {
        try (Session session = this.getSessionFactory().openSession();){
            NativeQuery query = session.createNativeQuery(sqlString);
            T t = function.apply(query);
            return t;
        }
    }

    private Iterable<SequenceInformation> getSchemaSequences(final String schemaName) throws SQLException {
        try (SessionImplementor session = (SessionImplementor)this.getSessionFactory().openSession();){
            Iterable iterable;
            block12: {
                JdbcConnectionAccess jdbcConnectionAccess = session.getJdbcConnectionAccess();
                final Connection connection = jdbcConnectionAccess.obtainConnection();
                try {
                    final JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)this.standardRegistry.getService(JdbcEnvironment.class);
                    ExtractionContext.EmptyExtractionContext extractionContext = new ExtractionContext.EmptyExtractionContext(){

                        public Connection getJdbcConnection() {
                            return connection;
                        }

                        public JdbcEnvironment getJdbcEnvironment() {
                            return jdbcEnvironment;
                        }

                        public Identifier getDefaultSchema() {
                            return Identifier.toIdentifier((String)schemaName);
                        }
                    };
                    iterable = this.getDialect().getSequenceInformationExtractor().extractMetadata((ExtractionContext)extractionContext);
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                connection.close();
            }
            return iterable;
        }
    }

    private List<String> getOracleSequences(String schemaName) {
        return this.executeNative(String.format("select SEQUENCE_NAME from all_sequences where SEQUENCE_OWNER = '%s'", schemaName.toUpperCase()), query -> query.getResultList());
    }

    private void createSequenceIfMissing(String wikiId) {
        block15: {
            if (!this.getAdapter().isCatalog() && this.getDialect().getNativeIdentifierGeneratorStrategy().equals("sequence")) {
                String schemaName = this.getAdapter().getDatabaseFromWikiName(wikiId);
                boolean ignoreError = false;
                try {
                    DatabaseProduct product = this.getDatabaseProductName();
                    if (product == DatabaseProduct.ORACLE) {
                        sequences = this.getOracleSequences(schemaName);
                        if (sequences.contains("HIBERNATE_SEQUENCE")) {
                            return;
                        }
                    } else {
                        sequences = this.getSchemaSequences(schemaName);
                        for (SequenceInformation sequenceInformation : sequences) {
                            QualifiedSequenceName sequenceName = sequenceInformation.getSequenceName();
                            if (!sequenceName.getSequenceName().getCanonicalName().equalsIgnoreCase("hibernate_sequence") || sequenceName.getSchemaName() == null || !sequenceName.getSchemaName().getCanonicalName().equals(schemaName)) continue;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Failed to get the sequences of the schema [{}] ({}). Trying to create hibernate_sequence anyway.", (Object)schemaName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    ignoreError = true;
                }
                try (Session session = this.getSessionFactory().openSession();){
                    Transaction transaction = session.beginTransaction();
                    session.createNativeQuery(String.format("create sequence %s.hibernate_sequence", schemaName)).executeUpdate();
                    transaction.commit();
                }
                catch (Exception e) {
                    if (ignoreError) break block15;
                    this.logger.error("Failed to create the hibernate_sequence", (Throwable)e);
                }
            }
        }
    }

    public synchronized void updateDatabase(String wikiId, boolean force) throws HibernateStoreException {
        if (!force && !this.hibernateConfiguration.isUpdateSchema()) {
            this.logger.debug("Database update deactivated for wiki [{}]", (Object)wikiId);
            return;
        }
        this.logger.info("Updating database for wiki [{}]...", (Object)wikiId);
        try {
            this.updateDatabase(wikiId);
        }
        finally {
            this.logger.info("Database update for wiki [{}] done", (Object)wikiId);
        }
    }

    public String getConfiguredColumnName(PersistentClass persistentClass, String propertyName) {
        String columnName = null;
        if (propertyName != null) {
            KeyValue identifier = persistentClass.getIdentifier();
            if (identifier instanceof org.hibernate.mapping.Component) {
                Iterator it = ((org.hibernate.mapping.Component)identifier).getPropertyIterator();
                while (it.hasNext()) {
                    Property property = (Property)it.next();
                    if (!property.getName().equals(propertyName)) continue;
                    return this.getConfiguredColumnName(property);
                }
            }
            return this.getConfiguredColumnName(persistentClass.getProperty(propertyName));
        }
        return columnName;
    }

    public String getConfiguredColumnName(Property property) {
        Column column = (Column)property.getColumnIterator().next();
        return this.getConfiguredColumnName(column);
    }

    public String getConfiguredColumnName(Column column) {
        String columnName = column.getName();
        if (this.getDatabaseProductName() == DatabaseProduct.POSTGRESQL) {
            columnName = columnName.toLowerCase();
        }
        return columnName;
    }

    public <R> R metadataTableOrColumn(Class<?> entityType, String propertyName, R def, ResultSetFunction<R> function) {
        String databaseName = this.getAdapter().getDatabaseFromWikiName();
        PersistentClass persistentClass = this.getConfigurationMetadata().getEntityBinding(entityType.getName());
        String tableName = this.getAdapter().getTableName(persistentClass);
        String columnName = this.getConfiguredColumnName(persistentClass, propertyName);
        return (R)this.metadata(def, (databaseMetaData, session) -> {
            String name = databaseName;
            try (ResultSet resultSet = columnName != null ? (this.getAdapter().isCatalog() ? databaseMetaData.getColumns(name, null, tableName, columnName) : databaseMetaData.getColumns(null, name, tableName, columnName)) : (this.getAdapter().isCatalog() ? databaseMetaData.getTables(name, null, tableName, null) : databaseMetaData.getTables(null, name, tableName, null));){
                if (resultSet.next()) {
                    Object r = function.apply(resultSet);
                    return r;
                }
            }
            return def;
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <R> R metadata(R def, DatabaseMetaDataFunction<R> function) {
        R result = def;
        try (SessionImplementor session = (SessionImplementor)this.getSessionFactory().openSession();){
            R r;
            block14: {
                JdbcConnectionAccess jdbcConnectionAccess = session.getJdbcConnectionAccess();
                Connection connection = jdbcConnectionAccess.obtainConnection();
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    r = function.apply(databaseMetaData, session);
                    if (connection == null) break block14;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                connection.close();
            }
            return r;
        }
        catch (SQLException e) {
            this.logger.error("Error while extracting metadata", (Throwable)e);
            return result;
        }
    }

    public int getLimitSize(Class<?> entityType, String propertyName) {
        int result = this.metadataTableOrColumn(entityType, propertyName, -1, resultSet -> resultSet.getInt("COLUMN_SIZE"));
        if (result == -1) {
            PersistentClass persistentClass = this.getConfigurationMetadata().getEntityBinding(entityType.getName());
            Column column2 = (Column)persistentClass.getProperty(propertyName).getColumnIterator().next();
            result = column2.getLength();
            this.logger.warn("Error while getting the size limit for entity [{}] and propertyName [{}]. The length value set by hibernate [{}] will be used.", new Object[]{entityType.getName(), propertyName, result});
        }
        return result;
    }

    public boolean tableExists(Class<?> entityClass) {
        return this.metadataTableOrColumn(entityClass, null, false, resultSet -> true);
    }

    public boolean isWikiDatabaseExist(String wikiName) {
        String databaseName = this.getAdapter().getDatabaseFromWikiName(wikiName);
        if (this.getAdapter().isCatalog()) {
            return this.isCatalogExist(databaseName);
        }
        return this.isSchemaExist(databaseName);
    }

    public boolean isCatalogExist(String catalogName) {
        return this.metadata(false, (metadata, session) -> {
            try (ResultSet catalogs = metadata.getCatalogs();){
                while (catalogs.next()) {
                    if (!catalogName.equalsIgnoreCase(catalogs.getString("TABLE_CAT"))) continue;
                    Boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
    }

    public boolean isSchemaExist(String schemaName) {
        return this.metadata(false, (metadata, session) -> {
            try (ResultSet schemas = this.configurationCatalog != null ? metadata.getSchemas(this.configurationCatalog, null) : metadata.getSchemas();){
                while (schemas.next()) {
                    if (!schemaName.equalsIgnoreCase(schemas.getString("TABLE_SCHEM"))) continue;
                    Boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
    }
}

