/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store;

import com.xpn.xwiki.store.AttachmentRecycleBinContentStore;
import com.xpn.xwiki.store.AttachmentRecycleBinStore;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import com.xpn.xwiki.store.XWikiAttachmentStoreInterface;
import com.xpn.xwiki.store.XWikiRecycleBinContentStoreInterface;
import com.xpn.xwiki.store.XWikiRecycleBinStoreInterface;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.store.XWikiVersioningStoreInterface;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;

@Component(roles={StoreConfiguration.class})
@Singleton
public class StoreConfiguration {
    private static final String FILE = "file";
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configuration;
    @Inject
    private Logger logger;

    private <S> S getStore(Class<S> storeClass, String property, String defaultHint) throws ComponentLookupException {
        return this.getStore(storeClass, property, defaultHint, false);
    }

    private <S> S getStore(Class<S> storeClass, String property, String defaultHint, boolean returnNullForHibernate) throws ComponentLookupException {
        String hint = (String)this.configuration.getProperty(property, (Object)defaultHint);
        if (returnNullForHibernate && hint.equals("hibernate")) {
            return null;
        }
        if (this.componentManager.hasComponent(storeClass, hint)) {
            return (S)this.componentManager.getInstance(storeClass, hint);
        }
        this.logger.warn("Can't find any implementation for the configured store with role [{}] and hint [{}]", storeClass, (Object)defaultHint);
        if (!defaultHint.equals(hint) && this.componentManager.hasComponent(storeClass, defaultHint)) {
            return (S)this.componentManager.getInstance(storeClass, defaultHint);
        }
        if (!defaultHint.equals("hibernate") && this.componentManager.hasComponent(storeClass, "hibernate")) {
            return (S)this.componentManager.getInstance(storeClass, "hibernate");
        }
        return null;
    }

    public XWikiStoreInterface getXWikiStore() throws ComponentLookupException {
        return this.getStore(XWikiStoreInterface.class, "xwiki.store.main.hint", "hibernate");
    }

    public XWikiVersioningStoreInterface getXWikiVersioningStore() throws ComponentLookupException {
        return this.getStore(XWikiVersioningStoreInterface.class, "xwiki.store.versioning.hint", "hibernate");
    }

    public XWikiRecycleBinStoreInterface getXWikiRecycleBinStore() throws ComponentLookupException {
        return this.isRecycleBinEnabled() ? this.getStore(XWikiRecycleBinStoreInterface.class, "xwiki.store.recyclebin.hint", "hibernate") : null;
    }

    public AttachmentRecycleBinStore getAttachmentRecycleBinStore() throws ComponentLookupException {
        return this.isAttachmentRecycleBinEnabled() ? this.getStore(AttachmentRecycleBinStore.class, "xwiki.store.attachment.recyclebin.hint", "hibernate") : null;
    }

    public XWikiAttachmentStoreInterface getXWikiAttachmentStore() throws ComponentLookupException {
        return this.getStore(XWikiAttachmentStoreInterface.class, "xwiki.store.attachment.hint", FILE);
    }

    public AttachmentVersioningStore getAttachmentVersioningStore() throws ComponentLookupException {
        return this.getStore(AttachmentVersioningStore.class, "xwiki.store.attachment.versioning.hint", this.isAttachmentVersioningEnabled() ? FILE : "void");
    }

    public XWikiRecycleBinContentStoreInterface getXWikiRecycleBinContentStore() throws ComponentLookupException {
        return this.getStore(XWikiRecycleBinContentStoreInterface.class, "xwiki.store.recyclebin.content.hint", FILE, true);
    }

    public AttachmentRecycleBinContentStore getAttachmentRecycleBinContentStore() throws ComponentLookupException {
        return this.getStore(AttachmentRecycleBinContentStore.class, "xwiki.store.attachment.recyclebin.content.hint", FILE, true);
    }

    public boolean isVersioningEnabled() {
        return !"0".equals(this.configuration.getProperty("xwiki.store.versioning", (Object)"1"));
    }

    public boolean isAttachmentVersioningEnabled() {
        return !"0".equals(this.configuration.getProperty("xwiki.store.attachment.versioning", (Object)"1"));
    }

    public boolean isRecycleBinEnabled() {
        return !"0".equals(this.configuration.getProperty("xwiki.recyclebin", (Object)"1"));
    }

    public boolean isAttachmentRecycleBinEnabled() {
        return !"0".equals(this.configuration.getProperty("storage.attachment.recyclebin", (Object)"1"));
    }

    public boolean isStoreCacheEnabled() {
        return !"0".equals(this.configuration.getProperty("xwiki.store.cache", (Object)"1"));
    }
}

