/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.store;

import com.xpn.xwiki.XWikiContext;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.WikiReference;

public abstract class AbstractXWikiStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXWikiStore.class);
    private static final String PREVIOUS_WIKI = AbstractXWikiStore.class.getName() + "#previouswiki";
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> readonlyxcontextProvider;

    protected XWikiContext getExecutionXContext(XWikiContext inputxcontext, boolean savewiki) {
        if (this.readonlyxcontextProvider == null) {
            return inputxcontext;
        }
        XWikiContext xcontext = (XWikiContext)this.readonlyxcontextProvider.get();
        if (xcontext == null) {
            return inputxcontext;
        }
        if (inputxcontext != null && xcontext != inputxcontext) {
            LOGGER.warn("ExecutionContext and passed XWikiContext argument mismatched, for data safety, the XWikiContext from the ExecutionContext has been used.", (Throwable)new Exception("Stack trace"));
            if (savewiki && !Objects.equals(inputxcontext.getWikiReference(), xcontext.getWikiReference())) {
                xcontext.put(PREVIOUS_WIKI, xcontext.getWikiReference());
                xcontext.setWikiReference(inputxcontext.getWikiReference());
            }
        }
        return xcontext;
    }

    protected void restoreExecutionXContext() {
        WikiReference wikiReference;
        XWikiContext xcontext;
        if (this.readonlyxcontextProvider != null && (xcontext = (XWikiContext)this.readonlyxcontextProvider.get()) != null && (wikiReference = (WikiReference)xcontext.remove(PREVIOUS_WIKI)) != null) {
            xcontext.setWikiReference(wikiReference);
        }
    }
}

