/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.skin;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiSkinFileOverrideClassDocumentInitializer;
import com.xpn.xwiki.internal.skin.AttachmentWikiResource;
import com.xpn.xwiki.internal.skin.ObjectPropertyWikiResource;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.skin.Resource;
import org.xwiki.skin.ResourceRepository;
import org.xwiki.skin.Skin;

@Component(roles={WikiSkinUtils.class})
@Singleton
public class WikiSkinUtils {
    public static final LocalDocumentReference SKINCLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiSkins");
    public static final String SKINCLASS_BASESKIN = "baseskin";
    private static final String NO_VALUE = "---";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    private Logger logger;

    public XWikiDocument getSkinDocument(String skin) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null) {
            DocumentReference skinReference = this.currentMixedDocumentReferenceResolver.resolve((Object)skin, new Object[0]);
            XWiki xwiki = xcontext.getWiki();
            if (xwiki != null && xwiki.getStore() != null) {
                XWikiDocument doc;
                try {
                    doc = xwiki.getDocument(skinReference, xcontext);
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to get document [{}]", (Object)skinReference, (Object)e);
                    return null;
                }
                if (!doc.isNew()) {
                    return doc;
                }
            }
        }
        return null;
    }

    private BaseObject getSkinObject(String skin) {
        XWikiDocument skinDocument = this.getSkinDocument(skin);
        return skinDocument != null ? skinDocument.getXObject((EntityReference)SKINCLASS_REFERENCE) : null;
    }

    public boolean isWikiSkin(String id) {
        return this.getSkinDocument(id) != null;
    }

    public Resource<?> getResource(String resourceName, Skin skin) {
        Resource<?> source = null;
        XWikiDocument skinDocument = this.getSkinDocument(skin.getId());
        if (skinDocument != null) {
            source = this.getSkinResourceFromDocumentSkin(resourceName, skinDocument, skin);
        }
        return source;
    }

    private Resource<?> getSkinResourceFromDocumentSkin(String resource, XWikiDocument skinDocument, Skin skin) {
        if (skinDocument != null) {
            BaseObject obj = skinDocument.getXObject(XWikiSkinFileOverrideClassDocumentInitializer.DOCUMENT_REFERENCE, "path", resource, false);
            if (obj != null) {
                ObjectPropertyReference reference = new ObjectPropertyReference("content", (ObjectReference)obj.getReference());
                return new ObjectPropertyWikiResource(this.getPath((EntityReference)reference), (ResourceRepository)skin, reference, skinDocument.getAuthorReference(), this.xcontextProvider, obj.getLargeStringValue("content"), skinDocument.getDate().toInstant());
            }
            BaseProperty<ObjectPropertyReference> property = this.getSkinResourceProperty(resource, skinDocument);
            if (property != null) {
                ObjectPropertyReference reference = (ObjectPropertyReference)property.getReference();
                return new ObjectPropertyWikiResource(this.getPath((EntityReference)reference), (ResourceRepository)skin, reference, skinDocument.getAuthorReference(), this.xcontextProvider, (String)property.getValue(), skinDocument.getDate().toInstant());
            }
            String normalizedResourceName = StringUtils.replaceChars((String)resource, (char)'/', (char)'.');
            XWikiAttachment attachment = skinDocument.getAttachment(normalizedResourceName);
            if (attachment != null) {
                AttachmentReference reference = attachment.getReference();
                return new AttachmentWikiResource(this.getPath((EntityReference)reference), (ResourceRepository)skin, reference, attachment.getAuthorReference(), this.xcontextProvider);
            }
        }
        return null;
    }

    private BaseProperty<ObjectPropertyReference> getSkinResourceProperty(String resource, XWikiDocument skinDocument) {
        BaseObject skinObject = skinDocument.getXObject((EntityReference)SKINCLASS_REFERENCE);
        if (skinObject != null) {
            Object value;
            BaseProperty resourceProperty = (BaseProperty)skinObject.safeget(resource);
            if (resourceProperty == null) {
                String escapedTemplateName = StringUtils.replaceChars((String)resource, (char)'/', (char)'.');
                resourceProperty = (BaseProperty)skinObject.safeget(escapedTemplateName);
            }
            if (resourceProperty != null && (value = resourceProperty.getValue()) instanceof String && StringUtils.isNotEmpty((CharSequence)((String)value))) {
                return resourceProperty;
            }
        }
        return null;
    }

    public String getSkinProperty(String skin, String property) {
        BaseObject obj = this.getSkinObject(skin);
        if (obj != null) {
            return obj.getStringValue(property);
        }
        return null;
    }

    public String getParentId(String id) {
        String parentId;
        BaseObject skinObject = this.getSkinObject(id);
        if (skinObject != null && StringUtils.isNotBlank((CharSequence)(parentId = skinObject.getStringValue(SKINCLASS_BASESKIN))) && !NO_VALUE.equals(parentId)) {
            return parentId;
        }
        return null;
    }

    private String getPath(EntityReference reference) {
        return (String)this.referenceSerializer.serialize(reference, new Object[0]);
    }
}

