/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.skin;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.skin.AbstractResource;
import com.xpn.xwiki.internal.skin.WikiResource;
import javax.inject.Provider;
import org.xwiki.filter.input.InputSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.skin.ResourceRepository;

public abstract class AbstractWikiResource<R extends EntityReference, I extends InputSource>
extends AbstractResource<I>
implements WikiResource<I> {
    protected final Provider<XWikiContext> xcontextProvider;
    protected final R reference;
    protected final DocumentReference authorReference;
    protected final DocumentReference documentReference;

    public AbstractWikiResource(String id, String path, String resourceName, ResourceRepository repository, R reference, DocumentReference authorReference, Provider<XWikiContext> xcontextProvider) {
        super(id, path, resourceName, repository);
        this.reference = reference;
        this.authorReference = authorReference;
        this.documentReference = (DocumentReference)this.reference.extractReference(EntityType.DOCUMENT);
        this.xcontextProvider = xcontextProvider;
    }

    @Override
    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    @Override
    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    protected XWikiDocument getDocument() throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
    }

    public String getURL(boolean forceSkinAction) throws Exception {
        return this.getURL(this.getDocument());
    }

    public abstract String getURL(XWikiDocument var1) throws Exception;
}

