/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.skin;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.skin.AbstractResource;
import com.xpn.xwiki.internal.template.InternalTemplateManager;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.LinkedHashMap;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.environment.Environment;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.skin.ResourceRepository;
import org.xwiki.url.URLConfiguration;

public abstract class AbstractSkinResource
extends AbstractResource<InputSource> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSkinResource.class);
    protected Environment environment;
    protected Provider<XWikiContext> xcontextProvider;
    protected URLConfiguration urlConfiguration;

    protected AbstractSkinResource(String id, String path, String resourceName, ResourceRepository repository, Environment environment, Provider<XWikiContext> xcontextProvider, URLConfiguration urlConfiguration) {
        super(id, path, resourceName, repository);
        this.environment = environment;
        this.xcontextProvider = xcontextProvider;
        this.urlConfiguration = urlConfiguration;
    }

    public InputSource getInputSource() {
        String path = this.getPath();
        InputStream inputStream = this.getResourceAsStream(path);
        if (inputStream != null) {
            return new DefaultInputStreamInputSource(inputStream, true);
        }
        return null;
    }

    public Instant getInstant() throws Exception {
        return InternalTemplateManager.getResourceInstant(this.environment, this.getPath());
    }

    public String getURL(boolean forceSkinAction) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (this.getURLConfiguration().useResourceLastModificationDate()) {
            try {
                URL resourceUrl = this.environment.getResource(this.getPath());
                Path resourcePath = Paths.get(resourceUrl.toURI());
                FileTime lastModifiedTime = Files.getLastModifiedTime(resourcePath, new LinkOption[0]);
                parameters.put("cache-version", String.valueOf(lastModifiedTime.toMillis()));
            }
            catch (Exception e) {
                parameters.put("cache-version", xcontext.getWiki().getVersion());
            }
        } else {
            parameters.put("cache-version", xcontext.getWiki().getVersion());
        }
        XWikiURLFactory urlf = xcontext.getURLFactory();
        URL url = forceSkinAction ? urlf.createSkinURL(this.resourceName, "skins", this.getRepository().getId(), xcontext, parameters) : urlf.createSkinURL(this.resourceName, this.getRepository().getId(), xcontext, parameters);
        return urlf.getURL(url, xcontext);
    }

    private URLConfiguration getURLConfiguration() {
        if (this.urlConfiguration == null) {
            this.urlConfiguration = Utils.getComponent(URLConfiguration.class);
        }
        return this.urlConfiguration;
    }

    public abstract InputStream getResourceAsStream(String var1);
}

