/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.skin;

import com.xpn.xwiki.internal.skin.AbstractResource;
import com.xpn.xwiki.internal.skin.AbstractSkin;
import com.xpn.xwiki.internal.skin.InternalSkinConfiguration;
import com.xpn.xwiki.internal.skin.InternalSkinManager;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.filter.input.InputSource;
import org.xwiki.skin.Resource;
import org.xwiki.skin.Skin;

public abstract class AbstractResourceSkin
extends AbstractSkin {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceSkin.class);
    private Configuration properties;

    public AbstractResourceSkin(String id, InternalSkinManager skinManager, InternalSkinConfiguration configuration, Logger logger) {
        super(id, skinManager, configuration, logger);
    }

    abstract AbstractResource<InputSource> createResource(String var1, String var2);

    abstract URL getResourceURL(String var1);

    @Override
    public String getOutputSyntaxString() {
        return this.getProperties().getString("outputSyntax");
    }

    @Override
    protected Skin createParent() {
        String parentId = this.getProperties().getString("parent");
        Skin skin = parentId != null ? (parentId.isEmpty() ? this.VOID : this.skinManager.getSkin(parentId)) : null;
        return skin;
    }

    public Resource<?> getLocalResource(String resourceName) {
        String resourcePath = this.getSkinResourcePath(resourceName);
        if (resourcePath != null && this.getResourceURL(resourcePath) != null) {
            return this.createResource(resourcePath, resourceName);
        }
        return null;
    }

    protected String getPropertiesPath() {
        return this.getSkinFolder() + "skin.properties";
    }

    protected String getSkinFolder() {
        return "skins/" + this.id + "/";
    }

    protected Configuration getProperties() {
        if (this.properties == null) {
            URL url = this.getResourceURL(this.getPropertiesPath());
            if (url != null) {
                try {
                    this.properties = new Configurations().properties(url);
                }
                catch (ConfigurationException e) {
                    LOGGER.error("Failed to load skin [{}] properties file ([])", new Object[]{this.id, url, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                    this.properties = new BaseConfiguration();
                }
            } else {
                LOGGER.debug("No properties found for skin [{}]", (Object)this.id);
                this.properties = new BaseConfiguration();
            }
        }
        return this.properties;
    }

    private String getSkinResourcePath(String resource) {
        String skinFolder = this.getSkinFolder();
        String resourcePath = skinFolder + resource;
        Path normalizedResource = Paths.get(resourcePath, new String[0]).normalize();
        if (!normalizedResource.startsWith(skinFolder)) {
            LOGGER.warn("Direct access to skin file [{}] refused. Possible break-in attempt!", (Object)normalizedResource);
            return null;
        }
        return resourcePath;
    }
}

