/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.security.authorization;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.AuthorExecutor;

@Component
@Singleton
public class DefaultAuthorExecutor
implements AuthorExecutor {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Execution execution;

    public <V> V call(Callable<V> callable, DocumentReference authorReference) throws Exception {
        return this.call(callable, authorReference, null);
    }

    public <V> V call(Callable<V> callable, DocumentReference authorReference, DocumentReference sourceReference) throws Exception {
        try (AutoCloseable context = this.before(authorReference, sourceReference);){
            V v = callable.call();
            return v;
        }
    }

    public AutoCloseable before(DocumentReference authorReference) {
        return this.before(authorReference, null);
    }

    private XWikiDocument getSecureDocument(XWikiContext xwikiContext, DocumentReference sourceReference, DocumentReference authorReference) {
        XWikiDocument secureDocument = null;
        if (sourceReference != null) {
            try {
                secureDocument = xwikiContext.getWiki().getDocument(sourceReference, xwikiContext);
                if (secureDocument.isNew() || !Objects.equals(secureDocument.getContentAuthorReference(), authorReference)) {
                    secureDocument = secureDocument.clone();
                    secureDocument.setContentAuthorReference(authorReference);
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to get document [{}]", (Object)sourceReference, (Object)e);
            }
        }
        if (secureDocument == null) {
            secureDocument = new XWikiDocument(new DocumentReference(authorReference != null ? authorReference.getWikiReference().getName() : "xwiki", "SUSpace", "SUPage"));
            secureDocument.setContentAuthorReference(authorReference);
            secureDocument.setAuthorReference(authorReference);
            secureDocument.setCreatorReference(authorReference);
        }
        return secureDocument;
    }

    public AutoCloseable before(DocumentReference authorReference, DocumentReference sourceReference) {
        DefaultAuthorExecutorContext suContext;
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        if (xwikiContext != null) {
            suContext = new DefaultAuthorExecutorContext();
            suContext.currentSecureDocument = (XWikiDocument)xwikiContext.get("sdoc");
            xwikiContext.put("sdoc", this.getSecureDocument(xwikiContext, sourceReference, authorReference));
            suContext.xwikiContextDropPermissionHack = xwikiContext.remove("hasDroppedPermissions");
            ExecutionContext econtext = this.execution.getContext();
            if (econtext != null) {
                suContext.documentDropPermissionHack = econtext.getProperty("hasDroppedPermissions");
                econtext.removeProperty("hasDroppedPermissions");
            }
        } else {
            suContext = null;
        }
        return suContext;
    }

    public void after(AutoCloseable context) {
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        if (xwikiContext != null) {
            DefaultAuthorExecutorContext internalContext = (DefaultAuthorExecutorContext)context;
            xwikiContext.put("sdoc", internalContext.currentSecureDocument);
            if (internalContext.xwikiContextDropPermissionHack != null) {
                xwikiContext.put("hasDroppedPermissions", internalContext.xwikiContextDropPermissionHack);
            }
            if (internalContext.documentDropPermissionHack != null) {
                ExecutionContext econtext = this.execution.getContext();
                econtext.setProperty("hasDroppedPermissions", internalContext.documentDropPermissionHack);
            }
        }
    }

    private final class DefaultAuthorExecutorContext
    implements AutoCloseable {
        private XWikiDocument currentSecureDocument;
        private Object xwikiContextDropPermissionHack;
        private Object documentDropPermissionHack;

        private DefaultAuthorExecutorContext() {
        }

        @Override
        public void close() throws Exception {
            DefaultAuthorExecutor.this.after(this);
        }
    }
}

