/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.render;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLink;
import com.xpn.xwiki.internal.cache.rendering.RenderingCache;
import com.xpn.xwiki.internal.render.OldRendering;
import com.xpn.xwiki.internal.render.groovy.ParseGroovyFromString;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.refactoring.ReferenceRenamer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Singleton
public class DefaultOldRendering
implements OldRendering {
    @Inject
    protected Provider<RenderingCache> cache;
    @Inject
    @Named(value="context")
    protected Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    @Named(value="compact")
    protected EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    protected DocumentReferenceResolver<EntityReference> defaultReferenceDocumentReferenceResolver;
    @Inject
    protected EntityReferenceResolver<ResourceReference> resourceReferenceResolver;
    @Inject
    protected Provider<VelocityManager> velocityManagerProvider;
    @Inject
    protected Provider<ParseGroovyFromString> parseGroovyFromString;
    @Inject
    protected Logger logger;
    @Inject
    protected ReferenceRenamer referenceRenamer;

    @Override
    public void renameLinks(XWikiDocument backlinkDocument, DocumentReference oldReference, DocumentReference newReference, XWikiContext context) throws XWikiException {
        if (((ComponentManager)this.contextComponentManagerProvider.get()).hasComponent(BlockRenderer.class, backlinkDocument.getSyntax().toIdString())) {
            this.refactorDocumentLinks(backlinkDocument, oldReference, newReference, context);
        }
    }

    @Override
    public void flushCache() {
        ((RenderingCache)this.cache.get()).flushWholeCache();
    }

    private void refactorDocumentLinks(XWikiDocument document, DocumentReference oldDocumentReference, DocumentReference newDocumentReference, XWikiContext context) throws XWikiException {
        this.referenceRenamer.renameReferences((Block)document.getXDOM(), document.getDocumentReference(), oldDocumentReference, newDocumentReference, false, Map.of(oldDocumentReference, newDocumentReference));
    }

    @Override
    public String parseContent(String content, XWikiContext xcontext) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)content)) {
                VelocityManager velocityManager = (VelocityManager)this.velocityManagerProvider.get();
                VelocityContext velocityContext = velocityManager.getVelocityContext();
                VelocityEngine velocityEngine = velocityManager.getVelocityEngine();
                StringWriter writer = new StringWriter();
                velocityEngine.evaluate((Context)velocityContext, (Writer)writer, xcontext.getDoc().getPrefixedFullName(), content);
                return writer.toString();
            }
        }
        catch (XWikiVelocityException e) {
            this.logger.error("Faield to parse content [" + content + "]", (Throwable)e);
        }
        return "";
    }

    @Override
    public Set<XWikiLink> extractLinks(XWikiDocument doc, XWikiContext context) throws XWikiException {
        return doc.getUniqueWikiLinkedPages(context);
    }

    @Override
    public void resetRenderingEngine(XWikiContext context) throws XWikiException {
    }

    @Override
    public String renderText(String text, XWikiDocument doc, XWikiContext xcontext) {
        return doc.getRenderedContent(text, doc.getSyntaxId(), xcontext);
    }

    @Override
    public String renderTemplate(String template, String skin, XWikiContext xcontext) {
        return xcontext.getWiki().parseTemplate(template, skin, xcontext);
    }

    @Override
    public String renderTemplate(String template, XWikiContext xcontext) {
        return xcontext.getWiki().parseTemplate(template, xcontext);
    }
}

