/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.plugin.rightsmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.plugin.rightsmanager.UserDataExtractor;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

public class UserIterator<T>
implements Iterator<T> {
    static final LocalDocumentReference GROUP_CLASS_REF = new LocalDocumentReference("XWiki", "XWikiGroups");
    static final LocalDocumentReference USER_CLASS_REF = new LocalDocumentReference("XWiki", "XWikiUsers");
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    private final Execution execution;
    private final XWikiContext xwikiContext;
    private List<DocumentReference> userAndGroupReferences;
    private List<DocumentReference> excludedUserAndGroupReferences;
    private List<DocumentReference> processedGroups = new ArrayList<DocumentReference>();
    private Deque<Iterator<DocumentReference>> userAndGroupIteratorStack = new ArrayDeque<Iterator<DocumentReference>>();
    private T lookaheadValue;
    private UserDataExtractor<T> userDataExtractor;

    public UserIterator(List<DocumentReference> userAndGroupReferences, List<DocumentReference> excludedUserAndGroupReferences, UserDataExtractor<T> userDataExtractor, DocumentReferenceResolver<String> explicitDocumentReferenceResolver, Execution execution) {
        this.initialize(userAndGroupReferences, excludedUserAndGroupReferences, userDataExtractor, explicitDocumentReferenceResolver);
        this.execution = execution;
        this.xwikiContext = null;
    }

    public UserIterator(DocumentReference userOrGroupReference, UserDataExtractor<T> userDataExtractor, DocumentReferenceResolver<String> explicitDocumentReferenceResolver, Execution execution) {
        this.initialize(userOrGroupReference, userDataExtractor, explicitDocumentReferenceResolver);
        this.execution = execution;
        this.xwikiContext = null;
    }

    public UserIterator(List<DocumentReference> userAndGroupReferences, List<DocumentReference> excludedUserAndGroupReferences, UserDataExtractor<T> userDataExtractor, DocumentReferenceResolver<String> explicitDocumentReferenceResolver, XWikiContext xwikiContext) {
        this.initialize(userAndGroupReferences, excludedUserAndGroupReferences, userDataExtractor, explicitDocumentReferenceResolver);
        this.execution = null;
        this.xwikiContext = xwikiContext;
    }

    public UserIterator(DocumentReference userOrGroupReference, UserDataExtractor<T> userDataExtractor, DocumentReferenceResolver<String> explicitDocumentReferenceResolver, XWikiContext xwikiContext) {
        this.initialize(userOrGroupReference, userDataExtractor, explicitDocumentReferenceResolver);
        this.execution = null;
        this.xwikiContext = xwikiContext;
    }

    private void initialize(DocumentReference userOrGroupReference, UserDataExtractor<T> userDataExtractor, DocumentReferenceResolver<String> explicitDocumentReferenceResolver) {
        List<DocumentReference> references = userOrGroupReference == null ? Collections.emptyList() : Collections.singletonList(userOrGroupReference);
        this.initialize(references, null, userDataExtractor, explicitDocumentReferenceResolver);
    }

    private void initialize(List<DocumentReference> userAndGroupReferences, List<DocumentReference> excludedUserAndGroupReferences, UserDataExtractor<T> userDataExtractor, DocumentReferenceResolver<String> explicitDocumentReferenceResolver) {
        this.userAndGroupReferences = userAndGroupReferences;
        this.excludedUserAndGroupReferences = excludedUserAndGroupReferences;
        if (excludedUserAndGroupReferences == null) {
            this.excludedUserAndGroupReferences = Collections.emptyList();
        }
        this.explicitDocumentReferenceResolver = explicitDocumentReferenceResolver;
        this.userDataExtractor = userDataExtractor;
        if (userAndGroupReferences != null && !userAndGroupReferences.isEmpty()) {
            this.userAndGroupIteratorStack.push(userAndGroupReferences.iterator());
        }
    }

    @Override
    public boolean hasNext() {
        if (this.lookaheadValue == null) {
            this.lookaheadValue = this.getNext();
        }
        return this.lookaheadValue != null;
    }

    @Override
    public T next() {
        T currentValue = this.lookaheadValue;
        if (currentValue != null) {
            this.lookaheadValue = null;
        } else {
            currentValue = this.getNext();
            if (currentValue == null) {
                throw new NoSuchElementException(String.format("No more users to extract from the passed references [%s]", this.serializeUserAndGroupReferences()));
            }
        }
        return currentValue;
    }

    private String serializeUserAndGroupReferences() {
        StringBuilder buffer = new StringBuilder();
        Iterator<DocumentReference> iterator = this.userAndGroupReferences.iterator();
        while (iterator.hasNext()) {
            DocumentReference reference = iterator.next();
            buffer.append('[').append(reference).append(']');
            if (!iterator.hasNext()) continue;
            buffer.append(',').append(' ');
        }
        return buffer.toString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private T getNext() {
        T currentValue = null;
        while (currentValue == null && !this.userAndGroupIteratorStack.isEmpty()) {
            currentValue = this.getNextUser(this.userAndGroupIteratorStack.peek());
        }
        return currentValue;
    }

    private T getNextUser(Iterator<DocumentReference> currentIterator) {
        T currentValue = null;
        DocumentReference currentReference = currentIterator.next();
        if (!this.excludedUserAndGroupReferences.contains(currentReference)) {
            if (this.isSuperAdmin(currentReference)) {
                currentValue = this.userDataExtractor.extractFromSuperadmin(currentReference);
            } else if (this.isGuest(currentReference)) {
                currentValue = this.userDataExtractor.extractFromGuest(currentReference);
            } else {
                XWikiDocument document = this.getFailsafeDocument(currentReference);
                if (document != null && !document.isNew()) {
                    currentValue = this.handleUserOrGroupReference(currentReference, document);
                }
            }
        }
        this.cleanStackIfNeeded(currentIterator);
        return currentValue;
    }

    private boolean isSuperAdmin(DocumentReference reference) {
        return reference.getLastSpaceReference().getName().equals("XWiki") && reference.getName().equalsIgnoreCase("superadmin");
    }

    private boolean isGuest(DocumentReference reference) {
        return reference.getLastSpaceReference().getName().equals("XWiki") && reference.getName().equals("XWikiGuest");
    }

    private T handleUserOrGroupReference(DocumentReference currentReference, XWikiDocument document) {
        boolean isGroupReference;
        T value = null;
        BaseObject userObject = document.getXObject((EntityReference)USER_CLASS_REF);
        boolean isUserReference = userObject != null;
        List<BaseObject> members = document.getXObjects((EntityReference)GROUP_CLASS_REF);
        boolean bl = isGroupReference = members != null && !members.isEmpty();
        if (isGroupReference && !this.processedGroups.contains(currentReference)) {
            this.processedGroups.add(currentReference);
            Collection<DocumentReference> groupMemberReferences = this.convertToDocumentReferences(members, currentReference);
            if (!groupMemberReferences.isEmpty()) {
                this.userAndGroupIteratorStack.push(groupMemberReferences.iterator());
            }
        }
        if (isUserReference) {
            value = this.userDataExtractor.extract(currentReference, document, userObject);
        }
        return value;
    }

    private void cleanStackIfNeeded(Iterator<DocumentReference> currentIterator) {
        while (!this.userAndGroupIteratorStack.isEmpty() && !this.userAndGroupIteratorStack.peek().hasNext()) {
            this.userAndGroupIteratorStack.pop();
        }
    }

    private XWikiDocument getFailsafeDocument(DocumentReference reference) {
        try {
            return this.getXwikiContext().getWiki().getDocument(reference, this.getXwikiContext());
        }
        catch (XWikiException e) {
            throw new RuntimeException(String.format("Failed to get document for User or Group [%s] when extracting all users for the references [%s]", reference, this.serializeUserAndGroupReferences()), e);
        }
    }

    private Collection<DocumentReference> convertToDocumentReferences(List<BaseObject> memberObjects, DocumentReference currentReference) {
        LinkedHashSet<DocumentReference> members = new LinkedHashSet<DocumentReference>();
        for (BaseObject memberObject : memberObjects) {
            DocumentReference resolvedReference;
            String member;
            if (memberObject == null || StringUtils.isBlank((CharSequence)(member = memberObject.getStringValue("member"))) || (resolvedReference = this.explicitDocumentReferenceResolver.resolve((Object)member, new Object[]{currentReference})).equals((Object)currentReference)) continue;
            members.add(resolvedReference);
        }
        return members;
    }

    protected XWikiContext getXwikiContext() {
        if (this.execution == null) {
            return this.xwikiContext;
        }
        XWikiContext context = null;
        ExecutionContext executionContext = this.execution.getContext();
        if (executionContext != null) {
            context = (XWikiContext)executionContext.getProperty("xwikicontext");
        }
        if (executionContext == null || context == null) {
            throw new RuntimeException(String.format("Aborting member extraction from passed references [%s] since no XWiki Context was found", this.serializeUserAndGroupReferences()));
        }
        return context;
    }
}

