/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.pdf;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.pdf.XSLFORenderer;
import com.xpn.xwiki.pdf.impl.PDFResourceResolver;
import com.xpn.xwiki.pdf.impl.XWikiFOPEventListener;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fop.apps.EnvironmentProfile;
import org.apache.fop.apps.EnvironmentalProfileFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.apps.PageSequenceResults;
import org.apache.fop.events.EventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;

@Component
@Singleton
@Named(value="fop")
public class FOPXSLFORenderer
implements XSLFORenderer,
Initializable {
    private static final String FONTS_PATH = "/WEB-INF/fonts/";
    private static final String RENDERERS = "renderers";
    private static final String MIME_TYPE_PDF = "application/pdf";
    private static final String MIME = "mime";
    private static final String FONTS = "fonts";
    @Inject
    private Logger logger;
    @Inject
    private PDFResourceResolver resourceResolver;
    @Inject
    private Environment environment;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private FopFactory fopFactory;

    public void initialize() throws InitializationException {
        EnvironmentProfile environmentProfile = EnvironmentalProfileFactory.createDefault((URI)this.getBaseURI(), (ResourceResolver)this.resourceResolver);
        FopFactoryBuilder builder = new FopFactoryBuilder(environmentProfile);
        this.setCacheFile(environmentProfile.getFontManager());
        Configuration configuration = this.loadConfiguration();
        if (configuration != null) {
            builder.setConfiguration(configuration);
        }
        this.fopFactory = builder.build();
    }

    @Override
    public void render(InputStream input2, OutputStream output, String outputFormat) throws Exception {
        FOUserAgent foUserAgent = this.fopFactory.newFOUserAgent();
        foUserAgent.getEventBroadcaster().addEventListener((EventListener)new XWikiFOPEventListener());
        Fop fop = this.fopFactory.newFop(outputFormat, foUserAgent, output);
        Transformer transformer = this.transformerFactory.newTransformer();
        StreamSource source = new StreamSource(input2);
        SAXResult result = new SAXResult(fop.getDefaultHandler());
        transformer.transform(source, result);
        FormattingResults foResults = fop.getResults();
        if (foResults != null && this.logger.isDebugEnabled()) {
            List pageSequences = foResults.getPageSequences();
            for (PageSequenceResults pageSequenceResults : pageSequences) {
                this.logger.debug("PageSequence " + (String)StringUtils.defaultIfEmpty((CharSequence)pageSequenceResults.getID(), (CharSequence)"<no id>") + " generated " + pageSequenceResults.getPageCount() + " pages.");
            }
            this.logger.debug("Generated " + foResults.getPageCount() + " pages in total.");
        }
    }

    private Configuration loadConfiguration() {
        Configuration configuration = null;
        try (InputStream fopConfigurationFile = FOPXSLFORenderer.class.getResourceAsStream("/fop-config.xml");){
            if (fopConfigurationFile != null) {
                configuration = new DefaultConfigurationBuilder().build(fopConfigurationFile);
            }
        }
        catch (Exception e) {
            this.logger.warn("Wrong FOP configuration: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        configuration = this.maybeExtendConfiguration(configuration);
        return configuration;
    }

    private Configuration maybeExtendConfiguration(Configuration configuration) {
        Configuration writableConfiguration = configuration;
        if (writableConfiguration != null) {
            if (!(writableConfiguration instanceof DefaultConfiguration)) {
                try {
                    writableConfiguration = new DefaultConfiguration(configuration, true);
                }
                catch (ConfigurationException e) {
                    this.logger.error("Failed to copy configuration.", (Throwable)e);
                }
            }
            if (writableConfiguration instanceof DefaultConfiguration) {
                this.extendConfiguration((DefaultConfiguration)writableConfiguration);
            }
        }
        return writableConfiguration;
    }

    private void extendConfiguration(DefaultConfiguration writableConfiguration) {
        try {
            DefaultConfiguration fontsConfiguration;
            DefaultConfiguration renderersConfiguration;
            XWikiRequest request;
            String fontsPath = this.environment.getResource(FONTS_PATH).getPath();
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            if (xcontext != null && (request = xcontext.getRequest()) != null && request.getSession() != null) {
                fontsPath = request.getSession().getServletContext().getRealPath(FONTS_PATH);
            }
            if ((renderersConfiguration = (DefaultConfiguration)writableConfiguration.getChild(RENDERERS, false)) == null) {
                renderersConfiguration = new DefaultConfiguration(RENDERERS);
                writableConfiguration.addChild((Configuration)renderersConfiguration);
            }
            DefaultConfiguration pdfRenderer = null;
            for (Configuration renderer : renderersConfiguration.getChildren()) {
                if (!MIME_TYPE_PDF.equals(renderer.getAttribute(MIME))) continue;
                pdfRenderer = (DefaultConfiguration)renderer;
            }
            if (pdfRenderer == null) {
                pdfRenderer = new DefaultConfiguration("renderer");
                pdfRenderer.setAttribute(MIME, MIME_TYPE_PDF);
                renderersConfiguration.addChild((Configuration)pdfRenderer);
            }
            if ((fontsConfiguration = (DefaultConfiguration)pdfRenderer.getChild(FONTS, false)) == null) {
                fontsConfiguration = new DefaultConfiguration(FONTS);
                pdfRenderer.addChild((Configuration)fontsConfiguration);
            }
            DefaultConfiguration directoryConfiguration = new DefaultConfiguration("directory");
            directoryConfiguration.setValue(fontsPath);
            fontsConfiguration.addChild((Configuration)directoryConfiguration);
        }
        catch (Exception e) {
            this.logger.warn("Starting with 1.5, XWiki uses the WEB-INF/fonts/ directory as the font directory, and it should contain the FreeFont (http://savannah.gnu.org/projects/freefont/) fonts. FOP cannot access this directory. If this is an upgrade from a previous version, make sure you also copy the WEB-INF/fonts directory from the new distribution package.");
        }
    }

    private void setCacheFile(FontManager fontManager) throws InitializationException {
        File cacheDirectory = new File(this.environment.getPermanentDirectory(), "cache");
        File fopDirectory = new File(cacheDirectory, "fop");
        File cacheFile = new File(fopDirectory, "fop-fonts.cache");
        try {
            FileUtils.forceMkdir((File)fopDirectory);
            fontManager.setCacheFile(cacheFile.toURI());
        }
        catch (IOException e) {
            throw new InitializationException(String.format("Failed to create FOP cache directory [%s]", fopDirectory), (Throwable)e);
        }
    }

    private URI getBaseURI() throws InitializationException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            return xcontext.getURLFactory().getServerURL(xcontext).toURI();
        }
        catch (Exception e) {
            throw new InitializationException("Failed to get the base URI for exporting to PDF", (Throwable)e);
        }
    }
}

