/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.observation.remote.converter;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.observation.remote.converter.AbstractXWikiEventConverter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.WikiCreatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;

@Component
@Singleton
@Named(value="wiki")
public class WikiEventConverter
extends AbstractXWikiEventConverter {
    private Set<Class<? extends Event>> events = new HashSet<Class<? extends Event>>(){
        {
            this.add(WikiDeletedEvent.class);
            this.add(WikiCreatedEvent.class);
        }
    };

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (this.events.contains(localEvent.getEvent().getClass())) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource((Serializable)((Object)((String)localEvent.getSource())));
            remoteEvent.setData(this.serializeXWikiContext((XWikiContext)localEvent.getData()));
            return true;
        }
        return false;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (this.events.contains(remoteEvent.getEvent().getClass())) {
            XWikiContext context = this.unserializeXWikiContext(remoteEvent.getData());
            if (context != null) {
                localEvent.setEvent((Event)remoteEvent.getEvent());
                localEvent.setSource((Object)remoteEvent.getSource());
                localEvent.setData((Object)this.unserializeXWikiContext(remoteEvent.getData()));
            }
            return true;
        }
        return false;
    }
}

