/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.observation.remote.converter;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.observation.remote.converter.AbstractXWikiEventConverter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.AbstractActionExecutionEvent;
import org.xwiki.bridge.event.ActionExecutedEvent;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;

@Component
@Singleton
@Named(value="action")
public class ActionExecutionEventConverter
extends AbstractXWikiEventConverter {
    private Set<String> actions = new HashSet<String>(){
        {
            this.add("upload");
        }
    };

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (localEvent.getEvent() instanceof ActionExecutedEvent || localEvent.getEvent() instanceof ActionExecutingEvent) {
            AbstractActionExecutionEvent event = (AbstractActionExecutionEvent)localEvent.getEvent();
            if (this.actions.contains(event.getActionName())) {
                remoteEvent.setEvent((Serializable)event);
                remoteEvent.setSource(this.serializeXWikiDocument((XWikiDocument)localEvent.getSource()));
                remoteEvent.setData(this.serializeXWikiContext((XWikiContext)localEvent.getData()));
            }
            return true;
        }
        return false;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (remoteEvent.getEvent() instanceof ActionExecutedEvent || remoteEvent.getEvent() instanceof ActionExecutingEvent) {
            XWikiContext xcontext = this.unserializeXWikiContext(remoteEvent.getData());
            try {
                if (xcontext != null) {
                    localEvent.setSource((Object)this.unserializeDocument(remoteEvent.getSource()));
                    localEvent.setData((Object)xcontext);
                    localEvent.setEvent((Event)remoteEvent.getEvent());
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to convert remote event [{}]", (Object)remoteEvent, (Object)e);
            }
            return true;
        }
        return false;
    }
}

