/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.observation.remote.converter;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.XWikiCacheStore;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.remote.converter.AbstractEventConverter;

public abstract class AbstractXWikiEventConverter
extends AbstractEventConverter {
    protected static final String CONTEXT_WIKI = "contextwiki";
    protected static final String CONTEXT_USER = "contextuser";
    protected static final String DOC_NAME = "docname";
    protected static final String DOC_VERSION = "docversion";
    protected static final String DOC_LANGUAGE = "doclanguage";
    protected static final String ORIGDOC_VERSION = "origdocversion";
    protected static final String ORIGDOC_LANGUAGE = "origdoclanguage";
    @Inject
    protected Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private XWikiStubContextProvider stubContextProvider;

    protected Serializable serializeXWikiContext(XWikiContext context) {
        HashMap<String, String> remoteDataMap = new HashMap<String, String>();
        remoteDataMap.put(CONTEXT_WIKI, context.getWikiId());
        remoteDataMap.put(CONTEXT_USER, context.getUser());
        return remoteDataMap;
    }

    private XWikiContext getXWikiStubContext() {
        ExecutionContext context = this.execution.getContext();
        XWikiContext xcontext = (XWikiContext)context.getProperty("xwikicontext");
        if (xcontext == null && (xcontext = this.stubContextProvider.createStubContext()) != null) {
            xcontext.declareInExecutionContext(context);
        }
        return xcontext;
    }

    protected XWikiContext unserializeXWikiContext(Serializable remoteData) {
        XWikiContext xcontext = this.getXWikiStubContext();
        Map remoteDataMap = (Map)((Object)remoteData);
        if (xcontext != null) {
            xcontext.setWikiId((String)remoteDataMap.get(CONTEXT_WIKI));
            xcontext.setUser((String)remoteDataMap.get(CONTEXT_USER));
        } else {
            this.logger.warn("Can't get a proper XWikiContext. It generally mean that the wiki has never been fully initialized, i.e. has never been accesses at least once");
        }
        return xcontext;
    }

    protected Serializable serializeXWikiDocument(XWikiDocument document) {
        XWikiDocument originalDocument;
        HashMap<String, Object> remoteDataMap = new HashMap<String, Object>();
        remoteDataMap.put(DOC_NAME, document.getDocumentReference());
        if (!document.isNew()) {
            remoteDataMap.put(DOC_VERSION, document.getVersion());
            remoteDataMap.put(DOC_LANGUAGE, document.getLanguage());
        }
        if ((originalDocument = document.getOriginalDocument()) != null && !originalDocument.isNew()) {
            remoteDataMap.put(ORIGDOC_VERSION, originalDocument.getVersion());
            remoteDataMap.put(ORIGDOC_LANGUAGE, originalDocument.getLanguage());
        }
        return remoteDataMap;
    }

    protected XWikiDocument getDocument(XWikiDocument document, String version, XWikiContext xcontext) throws XWikiException {
        XWikiDocument targetDocument = xcontext.getWiki().getDocument(document, xcontext);
        if (!targetDocument.getVersion().equals(version)) {
            targetDocument = xcontext.getWiki().getVersioningStore().loadXWikiDoc(document, version, xcontext);
        }
        return targetDocument;
    }

    protected XWikiDocument unserializeDocument(Serializable remoteData) throws XWikiException {
        String origVersion;
        String version;
        Map remoteDataMap = (Map)((Object)remoteData);
        DocumentReference docReference = (DocumentReference)remoteDataMap.get(DOC_NAME);
        Locale locale = LocaleUtils.toLocale((String)((String)remoteDataMap.get(DOC_LANGUAGE)));
        Locale origLocale = LocaleUtils.toLocale((String)((String)remoteDataMap.get(ORIGDOC_LANGUAGE)));
        XWikiContext xcontext = this.getXWikiStubContext();
        XWikiDocument document = new XWikiDocument(docReference, locale);
        XWikiDocument origDoc = new XWikiDocument(docReference, origLocale);
        if (xcontext.getWiki().getStore() instanceof XWikiCacheStore) {
            ((XWikiCacheStore)xcontext.getWiki().getStore()).invalidate(document);
            ((XWikiCacheStore)xcontext.getWiki().getStore()).invalidate(origDoc);
        }
        if ((version = (String)remoteDataMap.get(DOC_VERSION)) != null) {
            document = this.getDocument(document, version, xcontext);
        }
        if ((origVersion = (String)remoteDataMap.get(ORIGDOC_VERSION)) != null) {
            origDoc = this.getDocument(origDoc, origVersion, xcontext);
        }
        document = document.clone();
        document.setOriginalDocument(origDoc);
        return document;
    }
}

