/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AbstractXClassPropertyEvent;
import com.xpn.xwiki.internal.event.XClassPropertyAddedEvent;
import com.xpn.xwiki.internal.event.XClassPropertyUpdatedEvent;
import com.xpn.xwiki.internal.store.PropertyConverter;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
@Named(value="XClassMigratorListener")
public class XClassMigratorListener
extends AbstractEventListener {
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private PropertyConverter propertyConverter;
    @Inject
    private Logger logger;

    public XClassMigratorListener() {
        super(XClassMigratorListener.class.getName(), new Event[]{new XClassPropertyUpdatedEvent(), new XClassPropertyAddedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        BaseProperty previousProperty;
        BaseProperty newProperty;
        AbstractXClassPropertyEvent propertyEvent = (AbstractXClassPropertyEvent)event;
        XWikiDocument newDocument = (XWikiDocument)source;
        XWikiDocument previousDocument = newDocument.getOriginalDocument();
        PropertyClass newPropertyClass = (PropertyClass)newDocument.getXClass().getField(propertyEvent.getReference().getName());
        PropertyClass previousPropertyClass = (PropertyClass)previousDocument.getXClass().getField(propertyEvent.getReference().getName());
        boolean migrate = false;
        if (newPropertyClass != null && (migrate = (newProperty = newPropertyClass.newProperty()) == null ? false : (previousPropertyClass != null ? (previousProperty = previousPropertyClass.newProperty()) == null || newProperty.getClass() != previousProperty.getClass() : true))) {
            try {
                this.migrate(newPropertyClass, newProperty);
            }
            catch (QueryException e) {
                this.logger.error("Failed to migrate XClass property [{}]", newPropertyClass.getReference(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate(PropertyClass newPropertyClass, BaseProperty<?> newProperty) throws QueryException {
        ClassPropertyReference propertyReference = (ClassPropertyReference)newPropertyClass.getReference();
        EntityReference classReference = propertyReference.extractReference(EntityType.DOCUMENT);
        EntityReference wikiReference = propertyReference.extractReference(EntityType.WIKI);
        Query query = this.queryManager.createQuery("select distinct obj.name from BaseObject as obj where obj.className = :className", "hql");
        query.bindValue("className", this.localSerializer.serialize(classReference, new Object[0]));
        query.setWiki(wikiReference.getName());
        List documents = query.execute();
        if (!documents.isEmpty()) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            String currentWikiId = xcontext.getWikiId();
            try {
                xcontext.setWikiId(wikiReference.getName());
                for (String documentName : documents) {
                    try {
                        this.migrate(newPropertyClass, newProperty, documentName, xcontext);
                    }
                    catch (XWikiException e) {
                        this.logger.error("Failed to migrate property [{}] in document [{}]", (Object)propertyReference, (Object)documentName);
                    }
                }
            }
            finally {
                xcontext.setWikiId(currentWikiId);
            }
        }
    }

    private void migrate(PropertyClass newPropertyClass, BaseProperty<?> newProperty, String documentName, XWikiContext xcontext) throws XWikiException {
        ClassPropertyReference propertyReference = (ClassPropertyReference)newPropertyClass.getReference();
        EntityReference classReference = propertyReference.extractReference(EntityType.DOCUMENT);
        XWikiDocument document = xcontext.getWiki().getDocument(this.resolver.resolve((Object)documentName, new Object[]{classReference}), xcontext);
        if (!document.isNew()) {
            boolean modified = false;
            document = document.clone();
            for (BaseObject xobject : document.getXObjects(classReference)) {
                if (xobject == null) continue;
                BaseProperty property = (BaseProperty)xobject.getField(propertyReference.getName());
                if (property != null) {
                    modified = this.convert(xobject, property, newProperty, newPropertyClass);
                    continue;
                }
                modified = this.add(xobject, newPropertyClass);
            }
            if (modified) {
                xcontext.getWiki().saveDocument(document, "Migrated property [" + propertyReference.getName() + "] from class [" + (String)this.localSerializer.serialize(classReference, new Object[0]) + "]", xcontext);
            }
        }
    }

    private boolean add(BaseObject xobject, PropertyClass newPropertyClass) {
        xobject.safeput(newPropertyClass.getName(), newPropertyClass.newProperty());
        return true;
    }

    private boolean convert(BaseObject xobject, BaseProperty<?> property, BaseProperty<?> newProperty, PropertyClass newPropertyClass) {
        BaseProperty<?> convertedProperty;
        if (newProperty != null && property.getClass() != newProperty.getClass() && (convertedProperty = this.propertyConverter.convertProperty(property, newPropertyClass)) != null) {
            xobject.removeField(newPropertyClass.getName());
            xobject.safeput(newPropertyClass.getName(), convertedProperty);
            return true;
        }
        return false;
    }
}

