/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.objects.classes;

import com.xpn.xwiki.objects.classes.UsersClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultUsersQueryBuilder
implements QueryBuilder<UsersClass> {
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="document")
    private QueryFilter documentFilter;
    @Inject
    @Named(value="viewable")
    private QueryFilter viewableFilter;

    public Query build(UsersClass usersClass) throws QueryException {
        String statement = "select doc.fullName as userReference," + " firstName.value||' '||lastName.value as userName " + "from XWikiDocument doc, BaseObject obj, StringProperty firstName, StringProperty lastName " + "where doc.fullName = obj.name and obj.className = 'XWiki.XWikiUsers'" + " and obj.id = firstName.id.id and firstName.id.name = 'first_name'" + " and obj.id = lastName.id.id and lastName.id.name = 'last_name'" + " and doc.space = 'XWiki' " + "order by lower(firstName.value), firstName.value, lower(lastName.value), lastName.value";
        Query query = this.queryManager.createQuery(statement, "hql");
        query.addFilter(this.documentFilter);
        query.addFilter(this.viewableFilter);
        query.setWiki(usersClass.getOwnerDocument().getDocumentReference().getWikiReference().getName());
        return query;
    }
}

