/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.model.reference;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultStringEntityReferenceSerializer;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;

@Component
@Singleton
@Named(value="compact")
public class CompactStringEntityReferenceSerializer
extends DefaultStringEntityReferenceSerializer {
    @Inject
    @Named(value="current")
    private EntityReferenceProvider provider;

    public String serialize(EntityReference reference, Object ... parameters) {
        if (reference == null) {
            return null;
        }
        StringBuilder representation = new StringBuilder();
        List references = reference.getReversedReferenceChain();
        int i = 0;
        while (i < references.size()) {
            EntityReference currentReference = (EntityReference)references.get(i);
            EntityType currentType = currentReference.getType();
            while (++i < references.size() && ((EntityReference)references.get(i)).getType() == currentType) {
                currentReference = (EntityReference)references.get(i);
            }
            if (!this.shouldSerialize(currentReference, representation, currentReference == reference, parameters)) continue;
            this.serializeEntityReferenceType(currentReference, representation, currentReference == reference);
        }
        return representation.toString();
    }

    protected boolean shouldSerialize(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        boolean shouldPrint = false;
        if (isLastReference || representation.length() > 0) {
            shouldPrint = true;
        } else {
            EntityReference defaultReference = this.resolveDefaultReference(currentReference.getType(), parameters);
            if (defaultReference == null || !this.equal(defaultReference, currentReference)) {
                shouldPrint = true;
            }
        }
        return shouldPrint;
    }

    protected void serializeEntityReferenceType(EntityReference reference, StringBuilder representation, boolean isLastReference) {
        EntityReference parent = reference.getParent();
        if (parent != null && parent.getType() == reference.getType()) {
            this.serializeEntityReferenceType(parent, representation, false);
        }
        super.serializeEntityReference(reference, representation, isLastReference, new Object[0]);
    }

    protected boolean equal(EntityReference defaultReference, EntityReference currentReference) {
        EntityReference defaultReferenceIt = defaultReference;
        EntityReference currentReferenceIt = currentReference;
        while (defaultReferenceIt != null) {
            if (currentReferenceIt == null || defaultReferenceIt.getType() != currentReferenceIt.getType() || !defaultReferenceIt.getName().equals(currentReferenceIt.getName())) {
                return false;
            }
            defaultReferenceIt = defaultReferenceIt.getParent();
            currentReferenceIt = currentReferenceIt.getParent();
        }
        return true;
    }

    protected EntityReference resolveDefaultReference(EntityType type, Object ... parameters) {
        EntityReference referenceParameter;
        EntityReference extractedReference;
        EntityReference resolvedDefaultReference = null;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference && (extractedReference = (referenceParameter = (EntityReference)parameters[0]).extractReference(type)) != null) {
            EntityReference parent;
            resolvedDefaultReference = extractedReference;
            for (parent = resolvedDefaultReference.getParent(); parent != null && parent.getType() == resolvedDefaultReference.getType(); parent = parent.getParent()) {
            }
            if (parent != null) {
                resolvedDefaultReference = resolvedDefaultReference.removeParent(parent);
            }
        }
        if (resolvedDefaultReference == null) {
            resolvedDefaultReference = this.provider.getDefaultReference(type);
        }
        return resolvedDefaultReference;
    }
}

