/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.mandatory;

import com.xpn.xwiki.doc.AbstractMandatoryClassInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.sheet.SheetBinder;

@Component
@Named(value="XWiki.XWikiSkins")
@Singleton
public class XWikiSkinsDocumentInitializer
extends AbstractMandatoryClassInitializer {
    private static final String CLASS_REFERENCE_SPACE = "SkinsCode";
    private static final String CLASS_REFERENCE_NAME = "XWikiSkinsSheet";
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;

    public XWikiSkinsDocumentInitializer() {
        super((EntityReference)new LocalDocumentReference("XWiki", "XWikiSkins"));
    }

    @Override
    protected void createClass(BaseClass xclass) {
        xclass.addTextField("name", "Name", 30);
        xclass.addTextField("baseskin", "Base Skin", 30);
        xclass.addTextField("logo", "Logo", 30);
        xclass.addStaticListField("outputSyntax", "Output Syntax", "html/5.0=HTML 5|xhtml/1.0=XHTML 1.0");
        xclass.addTemplateField("style.css", "Style");
        xclass.addTemplateField("header.vm", "Header");
        xclass.addTemplateField("footer.vm", "Footer");
        xclass.addTemplateField("viewheader.vm", "View Header");
        xclass.addTemplateField("view.vm", "View");
        xclass.addTemplateField("edit.vm", "Edit");
    }

    @Override
    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = super.updateDocument(document);
        String wikiName = document.getDocumentReference().getWikiReference().getName();
        needsUpdate |= this.classSheetBinder.unbind((DocumentModelBridge)document, new DocumentReference(wikiName, "XWiki", CLASS_REFERENCE_NAME));
        if (this.classSheetBinder.getSheets((DocumentModelBridge)document).isEmpty()) {
            DocumentReference sheet = new DocumentReference(wikiName, CLASS_REFERENCE_SPACE, CLASS_REFERENCE_NAME);
            needsUpdate |= this.classSheetBinder.bind((DocumentModelBridge)document, sheet);
        }
        return needsUpdate;
    }
}

