/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.output;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.internal.doc.ListAttachmentArchive;
import com.xpn.xwiki.internal.filter.output.AbstractEntityOutputFilterStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiAttachmentOutputFilterStream
extends AbstractEntityOutputFilterStream<XWikiAttachment> {
    @Inject
    private Logger logger;

    private void setVersion(XWikiAttachment attachment, FilterEventParameters parameters) {
        String version;
        if (parameters.containsKey((Object)"revision") && (version = this.getString("revision", parameters, null)) != null) {
            if (VALID_VERSION.matcher(version).matches()) {
                attachment.setVersion(version);
            } else if (NumberUtils.isDigits((String)version)) {
                attachment.setVersion(version + ".1");
            }
        }
    }

    @Override
    public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws FilterException {
        this.fillAttachment(name, (InputSource)(content != null ? new DefaultInputStreamInputSource(content) : null), size, parameters);
    }

    @Override
    public void beginWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        this.fillAttachment(name, content, size, parameters);
    }

    @Override
    public void beginWikiAttachmentRevision(String version, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        if (this.entity != null && this.properties.isVersionPreserved()) {
            ListAttachmentArchive archive = this.getArchive();
            archive.add(this.createAttachment(((XWikiAttachment)this.entity).getFilename(), content, size, parameters));
        }
    }

    private ListAttachmentArchive getArchive() {
        ListAttachmentArchive archive = (ListAttachmentArchive)((XWikiAttachment)this.entity).getAttachment_archive();
        if (archive == null) {
            archive = new ListAttachmentArchive((XWikiAttachment)this.entity);
            ((XWikiAttachment)this.entity).setAttachment_archive(archive);
        }
        return archive;
    }

    private void fillAttachment(String name, InputSource source, Long size, FilterEventParameters parameters) throws FilterException {
        if (this.entity == null) {
            this.entity = new XWikiAttachment();
        }
        this.fillAttachment((XWikiAttachment)this.entity, name, source, size, parameters);
    }

    private XWikiAttachment createAttachment(String name, InputSource source, Long size, FilterEventParameters parameters) throws FilterException {
        XWikiAttachment attachment = new XWikiAttachment();
        this.fillAttachment(attachment, name, source, size, parameters);
        return attachment;
    }

    private void fillAttachment(XWikiAttachment attachment, String name, InputSource source, Long size, FilterEventParameters parameters) throws FilterException {
        attachment.setFilename(name);
        if (size != null) {
            attachment.setLongSize(size);
        }
        attachment.setMimeType(this.getString("mimetype", parameters, null));
        attachment.setCharset(this.getString("charset", parameters, null));
        this.fillAttachmentContent(attachment, source, parameters);
        attachment.setAuthorReference(this.getUserDocumentReference("revision_author", parameters, null));
        if (this.properties == null || this.properties.isVersionPreserved()) {
            this.setVersion(attachment, parameters);
            attachment.setComment(this.getString("revision_comment", parameters, ""));
            attachment.setDate(this.getDate("revision_date", parameters, new Date()));
            String revisions = this.getString("xwiki_jrcsrevisions", parameters, null);
            if (revisions != null) {
                try {
                    attachment.setArchive(revisions);
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to set the archive for attachment [{}]. This attachment won't have any history.", (Object)name, (Object)e);
                }
            }
            attachment.setMetaDataDirty(false);
        }
    }

    private void fillAttachmentContent(XWikiAttachment attachment, InputSource source, FilterEventParameters parameters) throws FilterException {
        block10: {
            if (source != null) {
                if (source instanceof InputStreamInputSource) {
                    try (InputStreamInputSource streamSource = (InputStreamInputSource)source;){
                        attachment.setContent(streamSource.getInputStream());
                        break block10;
                    }
                    catch (IOException e) {
                        throw new FilterException("Failed to set attachment content", (Throwable)e);
                    }
                }
                throw new FilterException("Unsupported input stream type [" + String.valueOf(source.getClass()) + "] for the attachment content");
            }
            this.fillAttachmentContentAlias(attachment, parameters);
        }
    }

    private void fillAttachmentContentAlias(XWikiAttachment attachment, FilterEventParameters parameters) throws FilterException {
        block18: {
            String alias = this.getString("revision_content_alias", parameters, null);
            if (alias != null) {
                if (alias.equals("")) {
                    try (InputStream stream = ((XWikiAttachment)this.entity).getContentInputStream(null);){
                        attachment.setContent(stream);
                        break block18;
                    }
                    catch (Exception e) {
                        throw new FilterException("Failed copy current attachment content", (Throwable)e);
                    }
                }
                try {
                    InputStream revisionContent = this.getArchive().getRevisionContentStream(alias, null);
                    if (revisionContent == null) break block18;
                    try (InputStream stream = revisionContent;){
                        attachment.setContent(stream);
                    }
                }
                catch (Exception e) {
                    throw new FilterException("Failed to copy content of attachment revision [" + alias + "]", (Throwable)e);
                }
            }
        }
    }
}

