/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.output;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import java.io.IOException;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.event.model.WikiDocumentFilter;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.output.AbstractBeanOutputFilterStream;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="xwiki+instance+document")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentInstanceOutputFilterStream
extends AbstractBeanOutputFilterStream<DocumentInstanceOutputProperties>
implements WikiDocumentFilter {
    private static final TranslationMarker LOG_DOCUMENT_CREATED = new TranslationMarker("filter.instance.log.document.created", new Marker[]{WikiDocumentFilter.LOG_DOCUMENT_CREATED});
    private static final TranslationMarker LOG_DOCUMENT_UPDATED = new TranslationMarker("filter.instance.log.document.updated", new Marker[]{WikiDocumentFilter.LOG_DOCUMENT_UPDATED});
    private static final TranslationMarker LOG_DOCUMENT_FAILSAVE = new TranslationMarker("filter.instance.log.document.failsave", new Marker[]{WikiDocumentFilter.LOG_DOCUMENT_ERROR});
    @Inject
    private FilterDescriptorManager filterManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityOutputFilterStream<XWikiDocument> documentListener;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;
    @Inject
    private Logger logger;
    private boolean firstVersion;
    private FilterEventParameters currentLocaleParameters;
    private FilterEventParameters currentRevisionParameters;

    protected Object createFilter() throws FilterException {
        return this.filterManager.createCompositeFilter(new Object[]{this.documentListener.getFilter(), this});
    }

    public void close() throws IOException {
    }

    public void setProperties(DocumentInstanceOutputProperties properties) throws FilterException {
        super.setProperties((Object)properties);
        this.documentListener.setProperties(properties);
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentLocaleParameters = parameters;
        this.currentRevisionParameters = parameters;
        this.firstVersion = true;
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.maybeSaveDocument();
        this.currentRevisionParameters = null;
        this.currentLocaleParameters = null;
        this.firstVersion = false;
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
        this.currentLocaleParameters = parameters;
        this.currentRevisionParameters = parameters;
        this.firstVersion = true;
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
        this.maybeSaveDocument();
        this.currentRevisionParameters = null;
        this.currentLocaleParameters = null;
        this.firstVersion = false;
    }

    public void beginWikiDocumentRevision(String version, FilterEventParameters parameters) throws FilterException {
        this.currentRevisionParameters = parameters;
    }

    public void endWikiDocumentRevision(String version, FilterEventParameters parameters) throws FilterException {
        this.maybeSaveDocument();
        this.currentRevisionParameters = null;
        this.firstVersion = false;
    }

    private void maybeSaveDocument() throws FilterException {
        block17: {
            XWikiDocument inputDocument = this.documentListener.getEntity();
            this.documentListener.setEntity(null);
            if (this.currentRevisionParameters == null) {
                return;
            }
            boolean hasJRCSHistory = inputDocument.getDocumentArchive() != null;
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            try {
                XWikiDocument document;
                XWikiDocument databaseDocument = xcontext.getWiki().getDocument(inputDocument.getDocumentReferenceWithLocale(), xcontext);
                boolean isnew = databaseDocument.isNew();
                databaseDocument.loadAttachmentsContentSafe(xcontext);
                if (this.firstVersion && ((DocumentInstanceOutputProperties)this.properties).isPreviousDeleted()) {
                    document = inputDocument;
                    document.setOriginalDocument(databaseDocument);
                } else {
                    document = databaseDocument.clone();
                    document.apply(inputDocument);
                    document.setMinorEdit(inputDocument.isMinorEdit());
                    if (((DocumentInstanceOutputProperties)this.properties).isAuthorPreserved()) {
                        this.setAuthors(document, inputDocument);
                    }
                }
                if (!((DocumentInstanceOutputProperties)this.properties).isAuthorPreserved()) {
                    if (((DocumentInstanceOutputProperties)this.properties).isAuthorSet()) {
                        this.setAuthorReference(document, ((DocumentInstanceOutputProperties)this.properties).getAuthor());
                    } else {
                        this.setAuthorReference(document, xcontext.getUserReference());
                    }
                    DocumentAuthors authors = document.getAuthors();
                    authors.setContentAuthor(authors.getEffectiveMetadataAuthor());
                    if (document.isNew()) {
                        authors.setCreator(authors.getEffectiveMetadataAuthor());
                    }
                }
                if (((DocumentInstanceOutputProperties)this.properties).isVersionPreserved()) {
                    document.setVersion(inputDocument.getVersion());
                    document.setDate(inputDocument.getDate());
                    document.setContentUpdateDate(inputDocument.getContentUpdateDate());
                    for (XWikiAttachment attachment : document.getAttachmentList()) {
                        attachment.setVersion(inputDocument.getAttachment(attachment.getFilename()).getVersion());
                    }
                    if (document.isNew()) {
                        document.setCreationDate(inputDocument.getCreationDate());
                        document.setDocumentArchive(inputDocument.getDocumentArchive());
                    }
                    document.setMetaDataDirty(false);
                    document.setContentDirty(false);
                    document.getAttachmentList().forEach(a -> a.setMetaDataDirty(false));
                    xcontext.getWiki().saveDocument(document, inputDocument.getComment(), inputDocument.isMinorEdit(), xcontext);
                } else {
                    document.setDocumentArchive((XWikiDocumentArchive)null);
                    xcontext.getWiki().saveDocument(document, ((DocumentInstanceOutputProperties)this.properties).getSaveComment(), xcontext);
                }
                if (((DocumentInstanceOutputProperties)this.properties).isVerbose()) {
                    if (isnew) {
                        this.logger.info((Marker)LOG_DOCUMENT_CREATED, "Created document [{}]", (Object)document.getDocumentReferenceWithLocale());
                    } else {
                        this.logger.info((Marker)LOG_DOCUMENT_UPDATED, "Updated document [{}]", (Object)document.getDocumentReferenceWithLocale());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Marker)LOG_DOCUMENT_FAILSAVE, "Failed to save document [{}]", (Object)inputDocument.getDocumentReferenceWithLocale(), (Object)e);
                if (!((DocumentInstanceOutputProperties)this.properties).isStoppedWhenSaveFail()) break block17;
                throw new FilterException("Failed to save document", (Throwable)e);
            }
        }
    }

    private void setAuthorReference(XWikiDocument document, DocumentReference authorReference) {
        UserReference authorUserReference = this.documentReferenceUserReferenceResolver.resolve((Object)authorReference, new Object[0]);
        document.setAuthor(authorUserReference);
        for (XWikiAttachment attachment : document.getAttachmentList()) {
            attachment.setAuthorReference(authorReference);
        }
    }

    private void setAuthors(XWikiDocument document, XWikiDocument inputDocument) {
        DocumentAuthors documentAuthors = document.getAuthors();
        DocumentAuthors inputDocumentAuthors = inputDocument.getAuthors();
        if (document.isNew()) {
            documentAuthors.copyAuthors(inputDocumentAuthors);
        } else {
            documentAuthors.setEffectiveMetadataAuthor(inputDocumentAuthors.getEffectiveMetadataAuthor());
            documentAuthors.setOriginalMetadataAuthor(inputDocumentAuthors.getOriginalMetadataAuthor());
            documentAuthors.setContentAuthor(inputDocumentAuthors.getContentAuthor());
        }
        for (XWikiAttachment currentAttachment : document.getAttachmentList()) {
            currentAttachment.setAuthorReference(inputDocument.getAttachment(currentAttachment.getFilename()).getAuthorReference());
        }
    }
}

