/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.output;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.filter.output.AbstractElementOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.BaseClassOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.BasePropertyOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.model.reference.EntityReference;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class BaseObjectOutputFilterStream
extends AbstractElementOutputFilterStream<BaseObject>
implements Initializable {
    @Inject
    private EntityOutputFilterStream<BaseClass> classFilter;
    @Inject
    private EntityOutputFilterStream<BaseProperty> propertyFilter;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private BaseObject externalEntity;
    private BaseClass databaseXClass;

    public void initialize() throws InitializationException {
        this.initialize(this.classFilter, this.propertyFilter);
    }

    @Override
    public void setEntity(BaseObject entity) {
        super.setEntity(entity);
        this.externalEntity = entity;
    }

    private BaseClassOutputFilterStream getBaseClassOutputFilterStream() {
        return (BaseClassOutputFilterStream)this.classFilter;
    }

    private BasePropertyOutputFilterStream getBasePropertyOutputFilterStream() {
        return (BasePropertyOutputFilterStream)this.propertyFilter;
    }

    private void setCurrentXClass(BaseClass xclass) {
        this.getBasePropertyOutputFilterStream().setCurrentXClass(xclass);
    }

    private BaseClass getCurrentXClass() {
        return this.getBasePropertyOutputFilterStream().getCurrentXClass();
    }

    @Override
    public void endWikiClass(FilterEventParameters parameters) throws FilterException {
        BaseClass xclass;
        if (this.entity != null && (xclass = (BaseClass)this.getBaseClassOutputFilterStream().getEntity()) != null) {
            if (this.externalEntity == null && StringUtils.isNotEmpty((CharSequence)xclass.getCustomClass())) {
                try {
                    BaseObject customObject = xclass.newCustomClassInstance(true);
                    customObject.setDocumentReference(((BaseObject)this.entity).getDocumentReference());
                    customObject.setXClassReference((EntityReference)((BaseObject)this.entity).getXClassReference());
                    customObject.setOwnerDocument(((BaseObject)this.entity).getOwnerDocument());
                    customObject.setGuid(((BaseObject)this.entity).getGuid());
                    customObject.apply((ElementInterface)this.entity, false);
                    this.entity = customObject;
                }
                catch (XWikiException xWikiException) {
                    // empty catch block
                }
            }
            this.setCurrentXClass(xclass);
            this.getBaseClassOutputFilterStream().setEntity(null);
        }
    }

    @Override
    public void beginWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        super.beginWikiObject(name, parameters);
        if (this.enabled) {
            if (this.entity == null) {
                this.entity = new BaseObject();
            }
            if (parameters.containsKey((Object)"name")) {
                ((BaseObject)this.entity).setDocumentReference(this.getDocumentReference("name", parameters, null));
            }
            int number = this.getInt("number", parameters, -1);
            EntityReference classReference = this.getEntityReference("class_reference", parameters, null);
            if (classReference == null) {
                BaseObjectReference reference = new BaseObjectReference(this.currentEntityReference);
                classReference = reference.getXClassReference();
                if (number < 0 && reference.getObjectNumber() != null) {
                    number = reference.getObjectNumber();
                }
            }
            ((BaseObject)this.entity).setXClassReference(classReference);
            this.checkDatabaseClass();
            ((BaseObject)this.entity).setNumber(number);
            ((BaseObject)this.entity).setGuid(this.getString("guid", parameters, null));
            this.getBaseClassOutputFilterStream().enable();
            this.getBasePropertyOutputFilterStream().enable();
        }
    }

    private void checkDatabaseClass() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            try {
                this.databaseXClass = xcontext.getWiki().getXClass(((BaseObject)this.entity).getXClassReference(), xcontext);
                if (!this.databaseXClass.getOwnerDocument().isNew()) {
                    this.setCurrentXClass(this.databaseXClass);
                } else {
                    this.databaseXClass = null;
                }
            }
            catch (XWikiException xWikiException) {
                // empty catch block
            }
        }
    }

    @Override
    public void endWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        if (this.entity != null) {
            BaseClass xclass = this.getCurrentXClass();
            if (xclass != null) {
                this.addMissingProperties(xclass);
            }
            if (this.databaseXClass != null && this.databaseXClass != xclass) {
                this.addMissingProperties(this.databaseXClass);
            }
        }
        super.endWikiObject(name, parameters);
        this.getBaseClassOutputFilterStream().disable();
        this.getBaseClassOutputFilterStream().disable();
    }

    private void addMissingProperties(BaseClass xclass) {
        for (String key : xclass.getPropertyList()) {
            PropertyClass classProperty;
            BaseProperty property;
            if (((BaseObject)this.entity).safeget(key) != null || (property = (classProperty = (PropertyClass)xclass.getField(key)).newProperty()) == null) continue;
            ((BaseObject)this.entity).safeput(key, property);
        }
    }

    @Override
    public void onWikiObjectProperty(String name, Object value, FilterEventParameters parameters) throws FilterException {
        if (this.enabled && this.getBasePropertyOutputFilterStream().getEntity() != null) {
            ((BaseObject)this.entity).safeput(name, (PropertyInterface)this.getBasePropertyOutputFilterStream().getEntity());
            this.getBasePropertyOutputFilterStream().setEntity(null);
        }
    }
}

