/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.output;

import com.xpn.xwiki.internal.filter.XWikiDocumentFilter;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilterCollection;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

public abstract class AbstractEntityOutputFilterStream<E>
implements EntityOutputFilterStream<E> {
    protected static final Pattern VALID_VERSION = Pattern.compile("\\d*\\.\\d*");
    protected E entity;
    protected DocumentInstanceOutputProperties properties;
    protected Object filter;
    protected EntityReference currentEntityReference;
    @Inject
    @Named(value="relative")
    protected EntityReferenceResolver<String> relativeResolver;
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<EntityReference> documentEntityResolver;
    @Inject
    @Named(value="current")
    protected EntityReferenceResolver<EntityReference> currentEntityResolver;
    @Inject
    @Named(value="user/current")
    protected DocumentReferenceResolver<EntityReference> userEntityResolver;
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<String> documentStringResolver;
    @Inject
    @Named(value="user/current")
    protected DocumentReferenceResolver<String> userStringResolver;
    @Inject
    @Named(value="document")
    protected UserReferenceResolver<DocumentReference> userDocumentResolver;
    @Inject
    protected ConverterManager converter;
    protected List<EntityOutputFilterStream<?>> children;
    protected boolean enabled = true;

    protected void initialize(EntityOutputFilterStream<?> ... children) {
        this.children = new ArrayList(children.length);
        for (EntityOutputFilterStream<?> child : children) {
            child.disable();
            this.children.add(child);
        }
    }

    protected void disableChildren() {
        if (this.children != null) {
            for (EntityOutputFilterStream<?> child : this.children) {
                child.disable();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.enabled = false;
        this.disableChildren();
    }

    @Override
    public Object getFilter() {
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
        return this.filter;
    }

    protected Object createFilter() {
        if (this.children != null) {
            ArrayList<XWikiDocumentFilter> filters = new ArrayList<XWikiDocumentFilter>(this.children.size() + 1);
            for (EntityOutputFilterStream<?> child : this.children) {
                filters.add((XWikiDocumentFilter)child.getFilter());
            }
            filters.add(this);
            return new XWikiDocumentFilterCollection(filters);
        }
        return this;
    }

    @Override
    public void setProperties(DocumentInstanceOutputProperties properties) {
        this.properties = properties;
        if (this.children != null) {
            for (EntityOutputFilterStream<?> child : this.children) {
                child.setProperties(properties);
            }
        }
    }

    @Override
    public E getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(E entity) {
        this.entity = entity;
    }

    protected <T> T get(Type type, String key, FilterEventParameters parameters, T def) {
        return this.get(type, key, parameters, def, true, true);
    }

    protected <T> T get(Type type, String key, FilterEventParameters parameters, T def, boolean replaceNull, boolean convert) {
        if (parameters == null) {
            return def;
        }
        if (!parameters.containsKey((Object)key)) {
            return def;
        }
        Object value = parameters.get((Object)key);
        if (value == null) {
            return (T)(replaceNull ? def : null);
        }
        if (TypeUtils.isInstance((Object)value, (Type)type)) {
            return (T)value;
        }
        return (T)(convert ? this.converter.convert(type, value) : value);
    }

    protected Date getDate(String key, FilterEventParameters parameters, Date def) {
        return this.get((Type)((Object)Date.class), key, parameters, (Object)def);
    }

    protected String getString(String key, FilterEventParameters parameters, String def) {
        return this.get((Type)((Object)String.class), key, parameters, (Object)def);
    }

    protected boolean getBoolean(String key, FilterEventParameters parameters, boolean def) {
        return this.get(Boolean.TYPE, key, parameters, def);
    }

    protected int getInt(String key, FilterEventParameters parameters, int def) {
        return this.get(Integer.TYPE, key, parameters, def);
    }

    protected Syntax getSyntax(String key, FilterEventParameters parameters, Syntax def) {
        return this.get((Type)((Object)Syntax.class), key, parameters, (Object)def);
    }

    protected EntityReference getEntityReference(String key, FilterEventParameters parameters, EntityReference def) {
        EntityReference reference = this.get((Type)((Object)Object.class), key, parameters, (Object)def, false, false);
        if (reference != null && !(reference instanceof EntityReference)) {
            reference = this.relativeResolver.resolve((Object)reference.toString(), EntityType.DOCUMENT, new Object[0]);
        }
        return reference;
    }

    protected EntityReference getDefaultReference() {
        if (this.properties != null && this.properties.getDefaultReference() != null) {
            return this.properties.getDefaultReference();
        }
        return null;
    }

    protected DocumentReference resolveCurrentDocumentReference() {
        return this.documentEntityResolver.resolve((Object)this.currentEntityReference, new Object[]{this.getDefaultReference()});
    }

    protected EntityReference resolveCurrentEntityReference() {
        return this.currentEntityReference != null ? this.currentEntityResolver.resolve((Object)this.currentEntityReference, this.currentEntityReference.getType(), new Object[]{this.getDefaultReference()}) : null;
    }

    protected DocumentReference getDocumentReference(String key, FilterEventParameters parameters, DocumentReference def) {
        DocumentReference reference = this.get((Type)((Object)Object.class), key, parameters, (Object)def, false, false);
        if (reference != null && !(reference instanceof DocumentReference)) {
            if (reference instanceof EntityReference) {
                EntityReference entityReference = (EntityReference)reference;
                reference = this.documentEntityResolver.resolve((Object)entityReference, new Object[]{this.resolveCurrentEntityReference()});
            } else {
                reference = this.documentStringResolver.resolve((Object)reference.toString(), new Object[]{this.resolveCurrentEntityReference()});
            }
        }
        return reference;
    }

    protected UserReference getUserReference(String key, FilterEventParameters parameters, UserReference def) {
        UserReference userReference = def;
        UserReference reference = this.get((Type)((Object)Object.class), key, parameters, (Object)def, false, false);
        if (reference != null && !(reference instanceof UserReference)) {
            userReference = reference instanceof DocumentReference ? this.userDocumentResolver.resolve((Object)((DocumentReference)reference), new Object[0]) : this.userDocumentResolver.resolve((Object)this.toUserDocumentReference(reference), new Object[0]);
        }
        return userReference;
    }

    protected DocumentReference getUserDocumentReference(String key, FilterEventParameters parameters, DocumentReference def) {
        DocumentReference userReference = def;
        DocumentReference reference = this.get((Type)((Object)Object.class), key, parameters, (Object)def, false, false);
        if (reference != null && !(reference instanceof DocumentReference)) {
            userReference = this.toUserDocumentReference(reference);
        }
        return userReference;
    }

    protected DocumentReference toUserDocumentReference(Object reference) {
        DocumentReference userDocumentReference = reference instanceof EntityReference ? this.userEntityResolver.resolve((Object)((EntityReference)reference), new Object[]{this.currentEntityReference != null ? this.currentEntityReference.extractReference(EntityType.WIKI) : null}) : this.userStringResolver.resolve((Object)reference.toString(), new Object[]{this.currentEntityReference != null ? this.currentEntityReference.extractReference(EntityType.WIKI) : null});
        if (userDocumentReference != null && userDocumentReference.getName().equals("XWikiGuest")) {
            userDocumentReference = null;
        }
        return userDocumentReference;
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = new EntityReference(name, EntityType.WIKI, this.currentEntityReference);
    }

    public void endWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    public void beginWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = new EntityReference(name, EntityType.SPACE, this.currentEntityReference);
    }

    public void endWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = new EntityReference(name, EntityType.DOCUMENT, this.currentEntityReference);
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiDocumentRevision(String revision, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiDocumentRevision(String revision, FilterEventParameters parameters) throws FilterException {
    }

    public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiAttachmentRevisions(FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiAttachmentRevisions(FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiAttachmentRevision(String revision, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiAttachmentRevision(String revision, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiClass(FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiClass(FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
    }

    public void onWikiClassPropertyField(String name, String value, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        if (name != null) {
            this.currentEntityReference = new EntityReference(name, EntityType.OBJECT, this.currentEntityReference);
        }
    }

    public void endWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        if (this.currentEntityReference.getType() == EntityType.OBJECT) {
            this.currentEntityReference = this.currentEntityReference.getParent();
        }
    }

    public void onWikiObjectProperty(String name, Object value, FilterEventParameters parameters) throws FilterException {
    }
}

