/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.input;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.input.XWikiAttachmentContentInputSource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputSourceReferenceParser;
import org.xwiki.model.reference.PageAttachmentReference;
import org.xwiki.model.reference.PageAttachmentReferenceResolver;

@Component
@Singleton
@Named(value="pageAttach")
public class XWikiPageAttachmentContentInputSourceReferenceParser
implements InputSourceReferenceParser {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="current")
    private PageAttachmentReferenceResolver<String> resolver;

    public InputSource parse(String reference) throws FilterException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            XWikiDocument document;
            PageAttachmentReference attachmentReference = this.resolver.resolve((Object)reference, new Object[0]);
            try {
                document = xcontext.getWiki().getDocument(attachmentReference.getPageReference(), xcontext);
            }
            catch (XWikiException e) {
                throw new FilterException("Failed to get attachment document for input source reference [" + reference + "]", (Throwable)e);
            }
            XWikiAttachment attachment = document.getAttachment(attachmentReference.getName());
            try {
                return new XWikiAttachmentContentInputSource(attachment.getAttachmentContent(xcontext));
            }
            catch (XWikiException e) {
                throw new FilterException("Failed to get attachment content for input source reference [" + reference + "]", (Throwable)e);
            }
        }
        throw new FilterException("Failed to get attachment for input source reference [" + reference + "]");
    }
}

