/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.instance.internal.InstanceModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceTree;
import org.xwiki.model.reference.EntityReferenceTreeNode;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.SpaceReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultInstanceModel
implements InstanceModel {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    private SpaceReferenceResolver<String> spaceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;

    public List<WikiReference> getWikiReferences() throws FilterException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            List<String> wikis = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            ArrayList<WikiReference> wikiReferences = new ArrayList<WikiReference>(wikis.size());
            for (String wikiName : wikis) {
                wikiReferences.add(new WikiReference((EntityReference)new WikiReference(wikiName)));
            }
            Collections.sort(wikis);
            return wikiReferences;
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get the list of wikis", (Throwable)e);
        }
    }

    public EntityReferenceTreeNode getSpaceReferences(WikiReference wikiReference) throws FilterException {
        List spaceReferenceStrings;
        try {
            spaceReferenceStrings = this.queryManager.getNamedQuery("getSpaces").setWiki(wikiReference.getName()).execute();
        }
        catch (QueryException e) {
            throw new FilterException(String.format("Failed to get the list of spaces in wiki [%s]", wikiReference), (Throwable)e);
        }
        ArrayList<SpaceReference> spaceReferences = new ArrayList<SpaceReference>(spaceReferenceStrings.size());
        for (String spaceReferenceString : spaceReferenceStrings) {
            spaceReferences.add(this.spaceResolver.resolve((Object)spaceReferenceString, new Object[]{wikiReference}));
        }
        EntityReferenceTree tree = new EntityReferenceTree(spaceReferences);
        return (EntityReferenceTreeNode)tree.getChildren().iterator().next();
    }

    public List<DocumentReference> getDocumentReferences(SpaceReference spaceReference) throws FilterException {
        List documentNames;
        try {
            Query query = this.queryManager.createQuery("select distinct doc.name from Document doc where doc.space = :space order by doc.name asc", "xwql");
            query.bindValue("space", this.localSerializer.serialize((EntityReference)spaceReference, new Object[0]));
            query.setWiki(spaceReference.getWikiReference().getName());
            documentNames = query.execute();
        }
        catch (QueryException e) {
            throw new FilterException(String.format("Failed to get the list of documents in space [%s]", spaceReference), (Throwable)e);
        }
        ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>(documentNames.size());
        for (String documentName : documentNames) {
            documentReferences.add(new DocumentReference(documentName, spaceReference));
        }
        return documentReferences;
    }
}

