/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.fileupload;

import com.xpn.xwiki.internal.fileupload.PartFileItemHeaders;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.io.IOUtils;

public class PartFileItem
implements FileItem {
    private final Part part;
    private final FileItemHeaders headers;

    public PartFileItem(Part part) {
        this.part = part;
        this.headers = new PartFileItemHeaders(part);
    }

    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(FileItemHeaders headers) {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream();
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    public String getName() {
        return this.part.getSubmittedFileName();
    }

    public boolean isInMemory() {
        return false;
    }

    public long getSize() {
        return this.part.getSize();
    }

    public byte[] get() {
        byte[] fileData = new byte[(int)this.getSize()];
        try (InputStream is = this.part.getInputStream();){
            IOUtils.readFully((InputStream)is, (byte[])fileData);
        }
        catch (IOException e) {
            fileData = null;
        }
        return fileData;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        String string;
        block8: {
            InputStream is = this.getInputStream();
            try {
                string = IOUtils.toString((InputStream)is, (String)encoding);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public String getString() {
        String encoding = this.getEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        try {
            return this.getString(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string;
            block11: {
                InputStream is = this.getInputStream();
                try {
                    string = new String(IOUtils.toByteArray((InputStream)is));
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                is.close();
            }
            return string;
        }
    }

    private String getEncoding() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(this.getContentType(), ';');
        return (String)params.get("charset");
    }

    public void write(File file) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void delete() {
        try {
            this.part.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFieldName() {
        return this.part.getName();
    }

    public void setFieldName(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean isFormField() {
        return this.part.getSubmittedFileName() == null;
    }

    public void setFormField(boolean state) {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

