/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.export;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.pdf.api.PdfExport;
import com.xpn.xwiki.pdf.impl.PdfExportImpl;
import com.xpn.xwiki.web.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.officeimporter.converter.OfficeConverter;
import org.xwiki.officeimporter.converter.OfficeConverterResult;
import org.xwiki.officeimporter.converter.OfficeDocumentFormat;
import org.xwiki.officeimporter.server.OfficeServer;

public class OfficeExporter
extends PdfExportImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeExporter.class);
    private OfficeServer officeServer = Utils.getComponent(OfficeServer.class);

    public PdfExport.ExportType getExportType(String fileName) {
        OfficeDocumentFormat format;
        if (this.officeServer.getState() == OfficeServer.ServerState.CONNECTED && (format = this.officeServer.getConverter().getDocumentFormat(fileName)) != null) {
            return new PdfExport.ExportType(format.getMediaType(), format.getExtension());
        }
        return null;
    }

    @Override
    protected void exportXHTML(String xhtml, OutputStream out, PdfExport.ExportType type, XWikiContext context) throws XWikiException {
        String html = this.applyXSLT(xhtml, this.getOfficeExportXSLT(context));
        String inputFileName = "export_input.html";
        String outputFileName = "export_output." + type.getExtension();
        HashMap<String, InputStream> inputStreams = new HashMap<String, InputStream>();
        Charset charset = Charset.forName(context.getWiki().getEncoding());
        inputStreams.put(inputFileName, new ByteArrayInputStream(html.getBytes(charset)));
        this.addEmbeddedObjects(inputStreams, context);
        OfficeConverter officeConverter = this.officeServer.getConverter();
        try (OfficeConverterResult officeConverterResult = officeConverter.convertDocument(inputStreams, inputFileName, outputFileName);){
            for (File file : officeConverterResult.getAllFiles()) {
                try (FileInputStream fis = new FileInputStream(file);){
                    IOUtils.write((byte[])IOUtils.toByteArray((InputStream)fis), (OutputStream)out);
                }
            }
        }
        catch (Exception e) {
            throw new XWikiException(12, 11011, String.format("Exception while exporting to %s (%s).", type.getMimeType(), type.getExtension()), e);
        }
    }

    private void addEmbeddedObjects(Map<String, InputStream> inputStreams, XWikiContext context) {
        Map fileMapping = (Map)context.get("pdfexport-file-mapping");
        for (File file : fileMapping.values()) {
            try {
                inputStreams.put(file.getName(), new FileInputStream(file));
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to embed %s in the office export.", file.getName()), (Throwable)e);
            }
        }
    }

    private InputStream getOfficeExportXSLT(XWikiContext context) {
        return this.getXslt("officeExportXSLT", "officeExport.xsl", context);
    }
}

