/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.event;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyAddedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyUpdatedEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.PropertyInterface;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="XObjectEventGeneratorListener")
public class XObjectEventGeneratorListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new DocumentDeletedEvent(), new DocumentCreatedEvent(), new DocumentUpdatedEvent());
    @Inject
    private ObservationManager observation;

    public String getName() {
        return "XObjectEventGeneratorListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument doc = (XWikiDocument)source;
        XWikiDocument originalDoc = doc.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        if (event instanceof DocumentUpdatedEvent) {
            this.onDocumentUpdatedEvent(originalDoc, doc, context);
        } else if (event instanceof DocumentDeletedEvent) {
            this.onDocumentDeletedEvent(originalDoc, doc, context);
        } else if (event instanceof DocumentCreatedEvent) {
            this.onDocumentCreatedEvent(originalDoc, doc, context);
        }
    }

    private void onDocumentCreatedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        for (List<BaseObject> xobjects : doc.getXObjects().values()) {
            for (BaseObject xobject : xobjects) {
                if (xobject == null) continue;
                this.observation.notify((Event)new XObjectAddedEvent((EntityReference)xobject.getReference()), (Object)doc, (Object)context);
                for (PropertyInterface property : xobject.getFieldList()) {
                    this.observation.notify((Event)new XObjectPropertyAddedEvent(property.getReference()), (Object)doc, (Object)context);
                }
            }
        }
    }

    private void onDocumentDeletedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        for (List<BaseObject> xobjects : originalDoc.getXObjects().values()) {
            for (BaseObject xobject : xobjects) {
                if (xobject == null) continue;
                this.observation.notify((Event)new XObjectDeletedEvent((EntityReference)xobject.getReference()), (Object)doc, (Object)context);
                for (PropertyInterface property : xobject.getFieldList()) {
                    this.observation.notify((Event)new XObjectPropertyDeletedEvent(property.getReference()), (Object)doc, (Object)context);
                }
            }
        }
    }

    private void onDocumentUpdatedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        for (List<ObjectDiff> objectChanges : doc.getObjectDiff(originalDoc, doc, context)) {
            boolean modified = false;
            for (ObjectDiff diff : objectChanges) {
                BaseObject xobject = doc.getXObject(diff.getXClassReference(), diff.getNumber());
                BaseObject xobjectOriginal = originalDoc.getXObject(diff.getXClassReference(), diff.getNumber());
                if ("object-removed".equals(diff.getAction())) {
                    this.observation.notify((Event)new XObjectDeletedEvent((EntityReference)xobjectOriginal.getReference()), (Object)doc, (Object)context);
                    continue;
                }
                if ("object-added".equals(diff.getAction())) {
                    this.observation.notify((Event)new XObjectAddedEvent((EntityReference)xobject.getReference()), (Object)doc, (Object)context);
                    continue;
                }
                if (!modified && xobject != null && xobjectOriginal != null) {
                    this.observation.notify((Event)new XObjectUpdatedEvent((EntityReference)xobject.getReference()), (Object)doc, (Object)context);
                    modified = true;
                }
                this.onObjectPropertyModified(doc, diff, context);
            }
        }
    }

    private void onObjectPropertyModified(XWikiDocument doc, ObjectDiff diff, XWikiContext context) {
        if ("removed".equals(diff.getAction())) {
            BaseObject object = doc.getOriginalDocument().getXObject(diff.getXClassReference(), diff.getNumber());
            PropertyInterface property = object.getField(diff.getPropName());
            this.observation.notify((Event)new XObjectPropertyDeletedEvent(property.getReference()), (Object)doc, (Object)context);
        } else {
            BaseObject object = doc.getXObject(diff.getXClassReference(), diff.getNumber());
            PropertyInterface property = object.getField(diff.getPropName());
            if ("added".equals(diff.getAction())) {
                this.observation.notify((Event)new XObjectPropertyAddedEvent(property.getReference()), (Object)doc, (Object)context);
            } else if ("changed".equals(diff.getAction())) {
                this.observation.notify((Event)new XObjectPropertyUpdatedEvent(property.getReference()), (Object)doc, (Object)context);
            }
        }
    }
}

