/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.event;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XClassPropertyAddedEvent;
import com.xpn.xwiki.internal.event.XClassPropertyDeletedEvent;
import com.xpn.xwiki.internal.event.XClassPropertyUpdatedEvent;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="XClassPropertyEventGeneratorListener")
public class XClassPropertyEventGeneratorListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new DocumentDeletedEvent(), new DocumentCreatedEvent(), new DocumentUpdatedEvent());
    @Inject
    private ObservationManager observation;

    public String getName() {
        return "XClassPropertyEventGeneratorListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument doc = (XWikiDocument)source;
        XWikiDocument originalDoc = doc.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        if (event instanceof DocumentUpdatedEvent) {
            this.onDocumentUpdatedEvent(originalDoc, doc, context);
        } else if (event instanceof DocumentDeletedEvent) {
            this.onDocumentDeletedEvent(originalDoc, doc, context);
        } else if (event instanceof DocumentCreatedEvent) {
            this.onDocumentCreatedEvent(originalDoc, doc, context);
        }
    }

    private void onDocumentCreatedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        for (PropertyInterface property : doc.getXClass().getFieldList()) {
            this.observation.notify((Event)new XClassPropertyAddedEvent(property.getReference()), (Object)doc, (Object)context);
        }
    }

    private void onDocumentDeletedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        for (PropertyInterface property : originalDoc.getXClass().getFieldList()) {
            this.observation.notify((Event)new XClassPropertyDeletedEvent(property.getReference()), (Object)doc, (Object)context);
        }
    }

    private void onDocumentUpdatedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        BaseClass baseClass = doc.getXClass();
        BaseClass baseClassOriginal = originalDoc.getXClass();
        for (List<ObjectDiff> objectChanges : doc.getClassDiff(originalDoc, doc, context)) {
            for (ObjectDiff diff : objectChanges) {
                PropertyInterface property = baseClass.getField(diff.getPropName());
                PropertyInterface propertyOriginal = baseClassOriginal.getField(diff.getPropName());
                if ("removed".equals(diff.getAction())) {
                    this.observation.notify((Event)new XClassPropertyDeletedEvent(propertyOriginal.getReference()), (Object)doc, (Object)context);
                    continue;
                }
                if ("added".equals(diff.getAction())) {
                    this.observation.notify((Event)new XClassPropertyAddedEvent(property.getReference()), (Object)doc, (Object)context);
                    continue;
                }
                if (!"changed".equals(diff.getAction())) continue;
                this.observation.notify((Event)new XClassPropertyUpdatedEvent(property.getReference()), (Object)doc, (Object)context);
            }
        }
    }
}

