/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.event;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.CommentAddedEvent;
import com.xpn.xwiki.internal.event.CommentDeletedEvent;
import com.xpn.xwiki.internal.event.CommentUpdatedEvent;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.internal.mandatory.XWikiCommentsDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.RegexEntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="CommentEventGeneratorListener")
public class CommentEventGeneratorListener
extends AbstractEventListener {
    private static final RegexEntityReference COMMENTCLASS_REFERENCE = XWikiCommentsDocumentInitializer.OBJECT_REFERENCE;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private ObservationManager observation;

    public CommentEventGeneratorListener() {
        super("CommentEventGeneratorListener", new Event[]{new XObjectAddedEvent((EntityReference)COMMENTCLASS_REFERENCE), new XObjectDeletedEvent((EntityReference)COMMENTCLASS_REFERENCE), new XObjectUpdatedEvent((EntityReference)COMMENTCLASS_REFERENCE)});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument doc = (XWikiDocument)source;
        XWikiDocument originalDoc = doc.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        XObjectEvent objectEvent = (XObjectEvent)event;
        String reference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0]);
        if (event instanceof XObjectDeletedEvent) {
            BaseObject obj = originalDoc.getXObject((ObjectReference)objectEvent.getReference());
            String number = String.valueOf(obj.getNumber());
            this.observation.notify((Event)new CommentDeletedEvent(reference, number), source, (Object)context);
        } else {
            BaseObject obj = doc.getXObject((ObjectReference)objectEvent.getReference());
            String number = String.valueOf(obj.getNumber());
            if (event instanceof XObjectAddedEvent) {
                this.observation.notify((Event)new CommentAddedEvent(reference, number), source, (Object)context);
            } else {
                this.observation.notify((Event)new CommentUpdatedEvent(reference, number), source, (Object)context);
            }
        }
    }
}

