/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.event;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.AttachmentDiff;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AttachmentAddedEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import com.xpn.xwiki.web.Utils;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="AttachmentEventGeneratorListener")
public class AttachmentEventGeneratorListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new DocumentDeletedEvent(), new DocumentCreatedEvent(), new DocumentUpdatedEvent());
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;

    public String getName() {
        return "AttachmentEventGeneratorListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument doc = (XWikiDocument)source;
        XWikiDocument originalDoc = doc.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        if (event instanceof DocumentUpdatedEvent) {
            this.onDocumentUpdatedEvent(originalDoc, doc, context);
        } else if (event instanceof DocumentDeletedEvent) {
            this.onDocumentDeletedEvent(originalDoc, doc, context);
        } else if (event instanceof DocumentCreatedEvent) {
            this.onDocumentCreatedEvent(originalDoc, doc, context);
        }
    }

    private void onDocumentCreatedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        ObservationManager observation = Utils.getComponent(ObservationManager.class);
        for (XWikiAttachment attachment : doc.getAttachmentList()) {
            String reference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)attachment.getDoc().getDocumentReference(), new Object[0]);
            observation.notify((Event)new AttachmentAddedEvent(reference, attachment.getFilename()), (Object)doc, (Object)context);
        }
    }

    private void onDocumentDeletedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        ObservationManager observation = Utils.getComponent(ObservationManager.class);
        for (XWikiAttachment attachment : originalDoc.getAttachmentList()) {
            String reference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)attachment.getDoc().getDocumentReference(), new Object[0]);
            observation.notify((Event)new AttachmentDeletedEvent(reference, attachment.getFilename()), (Object)doc, (Object)context);
        }
    }

    private void onDocumentUpdatedEvent(XWikiDocument originalDoc, XWikiDocument doc, XWikiContext context) {
        ObservationManager observation = Utils.getComponent(ObservationManager.class);
        String reference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0]);
        for (AttachmentDiff diff : doc.getAttachmentDiff(originalDoc, doc, context)) {
            if (StringUtils.isEmpty((CharSequence)diff.getOrigVersion())) {
                observation.notify((Event)new AttachmentAddedEvent(reference, diff.getFileName()), (Object)doc, (Object)context);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)diff.getNewVersion())) {
                observation.notify((Event)new AttachmentDeletedEvent(reference, diff.getFileName()), (Object)doc, (Object)context);
                continue;
            }
            observation.notify((Event)new AttachmentUpdatedEvent(reference, diff.getFileName()), (Object)doc, (Object)context);
        }
    }
}

