/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.doc;

import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections4.list.AbstractListDecorator;
import org.xwiki.stability.Unstable;

public class XWikiAttachmentList
extends AbstractListDecorator<XWikiAttachment>
implements XWikiAttachment.AttachmentContainer {
    private final Map<String, XWikiAttachment> map = new ConcurrentSkipListMap<String, XWikiAttachment>();
    private final List<XWikiAttachment> emptyNameAttachments = new CopyOnWriteArrayList<XWikiAttachment>();
    private final XWikiDocument document;

    public XWikiAttachmentList(XWikiDocument document) {
        super(new ArrayList());
        this.document = document;
    }

    public boolean add(XWikiAttachment attachment) {
        XWikiAttachment set = this.set(attachment);
        return set != attachment;
    }

    public void add(int index, XWikiAttachment attachment) {
        this.add(attachment);
    }

    public void clear() {
        this.map.clear();
        this.updateList();
    }

    public boolean addAll(Collection<? extends XWikiAttachment> c) {
        boolean changed = false;
        for (XWikiAttachment xWikiAttachment : c) {
            XWikiAttachment put = this.map.put(xWikiAttachment.getFilename(), xWikiAttachment);
            if (put == xWikiAttachment) continue;
            changed = true;
            this.added(xWikiAttachment);
        }
        if (changed) {
            this.updateList();
        }
        return changed;
    }

    public boolean addAll(int index, Collection<? extends XWikiAttachment> c) {
        return this.addAll(c);
    }

    public XWikiAttachment remove(int index) {
        XWikiAttachment removedAttachment = this.map.remove(((XWikiAttachment)this.decorated().get(index)).getFilename());
        if (removedAttachment != null) {
            this.updateList();
        }
        return removedAttachment;
    }

    public boolean remove(Object attachment) {
        XWikiAttachment xwikiAttachment = (XWikiAttachment)attachment;
        if (xwikiAttachment != null) {
            if (xwikiAttachment.getFilename() != null) {
                if (this.map.remove(xwikiAttachment.getFilename()) != null) {
                    this.updateList();
                    return true;
                }
            } else if (this.emptyNameAttachments.remove(xwikiAttachment)) {
                this.updateList();
                return true;
            }
        }
        return false;
    }

    public XWikiAttachment set(XWikiAttachment attachment) {
        XWikiAttachment previous;
        if (attachment.getFilename() != null) {
            previous = this.map.put(attachment.getFilename(), attachment);
            if (previous != attachment) {
                this.added(attachment);
                this.updateList();
            }
        } else {
            this.emptyNameAttachments.add(attachment);
            previous = null;
        }
        return previous;
    }

    public XWikiAttachment set(int index, XWikiAttachment attachment) {
        return this.set(attachment);
    }

    public XWikiAttachment getByFilename(String filename) {
        return filename != null ? this.map.get(filename) : null;
    }

    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (XWikiAttachment x : c) {
            if (this.map.get(x.getFilename()) != x) continue;
            this.map.remove(x.getFilename());
            changed = true;
        }
        if (changed) {
            this.updateList();
        }
        return changed;
    }

    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Collection<XWikiAttachment> values = this.map.values();
        for (XWikiAttachment x : values) {
            if (c.contains(x)) continue;
            this.map.remove(x.getFilename());
            changed = true;
        }
        if (changed) {
            this.updateList();
        }
        return changed;
    }

    private void updateList() {
        this.document.setMetaDataDirty(true);
        ArrayList<XWikiAttachment> list = new ArrayList<XWikiAttachment>(this.map.values());
        list.addAll(this.emptyNameAttachments);
        this.setCollection(list);
    }

    protected void added(XWikiAttachment element) {
        element.setDoc(this.document);
        element.setAttachmentContainer(this);
    }

    protected void removed(XWikiAttachment element) {
        element.setAttachmentContainer(null);
    }

    @Override
    public void onAttachmentNameModified(String previousAttachmentName, XWikiAttachment attachment) {
        boolean removed = previousAttachmentName != null ? this.map.remove(previousAttachmentName) == attachment : this.emptyNameAttachments.remove(attachment);
        if (removed) {
            this.set(attachment);
        }
    }

    @Unstable
    public void setDirty(boolean dirty, boolean deep) {
        this.map.values().forEach(attachment -> attachment.setDirty(dirty, deep));
    }
}

